/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.lpgextensions;

import java.util.LinkedList;
import lpg.lpgjavaruntime.BadParseException;
import lpg.lpgjavaruntime.BadParseSymFileException;
import lpg.lpgjavaruntime.ConfigurationElement;
import lpg.lpgjavaruntime.ConfigurationStack;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.NotBacktrackParseTableException;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.ITrialUndoActionProvider;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.ParserState;
import org.eclipse.cdt.core.dom.lrparser.lpgextensions.Rule;

public class TrialUndoParser {
    private Monitor monitor = null;
    private int START_STATE;
    private int NUM_RULES;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ERROR_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private TokenStream tokStream;
    private ParseTable prs;
    private ITrialUndoActionProvider actionProvider;
    private boolean skipTokens = false;
    private ParserState state;
    private boolean backtrackRequested;

    public final int getToken(int i) {
        return this.state.tokens.get(this.state.parserLocationStack[this.state.stateStackTop + (i - 1)]);
    }

    public int getTokenOffset() {
        return this.state.parserLocationStack[this.state.stateStackTop];
    }

    public final int getCurrentRule() {
        return this.state.currentAction;
    }

    public final int getFirstToken() {
        return this.tokStream.getFirstErrorToken(this.getToken(1));
    }

    public final int getFirstToken(int i) {
        return this.tokStream.getFirstErrorToken(this.getToken(i));
    }

    public final int getLastToken() {
        return this.tokStream.getLastErrorToken(this.state.lastToken);
    }

    public final int getLastToken(int i) {
        int l = i >= this.prs.rhs(this.state.currentAction) ? this.state.lastToken : this.state.tokens.get(this.state.locationStack[this.state.stateStackTop + i] - 1);
        return this.tokStream.getLastErrorToken(l);
    }

    public TrialUndoParser(TokenStream tokStream, ParseTable prs, ITrialUndoActionProvider ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.tokStream = tokStream;
        this.prs = prs;
        this.actionProvider = ra;
        this.START_STATE = prs.getStartState();
        this.NUM_RULES = prs.getNumRules();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ERROR_SYMBOL = prs.getErrorSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        if (!prs.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (!prs.getBacktrack()) {
            throw new NotBacktrackParseTableException();
        }
    }

    public TrialUndoParser(Monitor monitor, TokenStream tokStream, ParseTable prs, ITrialUndoActionProvider ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this(tokStream, prs, ra);
        this.monitor = monitor;
    }

    public Object parse() throws BadParseException {
        return this.parse(0);
    }

    public Object parse(int max_error_count) throws BadParseException {
        int initial_error_token;
        this.state = new ParserState(this.START_STATE, this.tokStream);
        this.skipTokens = max_error_count < 0;
        this.state.pendingCommits = new LinkedList();
        this.backtrackRequested = false;
        this.state.trialActionCount = 0;
        this.state.repair_token = 0;
        int start_token_index = this.tokStream.peek();
        int start_action_index = 0;
        int[] temp_stack = new int[]{this.START_STATE};
        this.state.reallocateOtherStacks(start_token_index);
        int error_token = initial_error_token = this.backtrackParse(this.state.repair_token);
        int count = 0;
        while (error_token != 0) {
            if (count == max_error_count) {
                throw new BadParseException(initial_error_token);
            }
            this.state.actionCount = start_action_index;
            this.tokStream.reset(start_token_index);
            this.state.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.state.stateStack, 0, temp_stack.length);
            this.state.reallocateOtherStacks(start_token_index);
            this.backtrackParseUpToError(this.state.repair_token, error_token);
            this.state.stateStackTop = this.findRecoveryStateIndex(this.state.stateStackTop);
            while (this.state.stateStackTop >= 0) {
                int recovery_token = this.state.tokens.get(this.state.locationStack[this.state.stateStackTop] - 1);
                this.state.repair_token = this.errorRepair(recovery_token >= start_token_index ? recovery_token : error_token, error_token);
                if (this.state.repair_token != 0) break;
                this.state.stateStackTop = this.findRecoveryStateIndex(this.state.stateStackTop - 1);
            }
            if (this.state.stateStackTop < 0) {
                throw new BadParseException(initial_error_token);
            }
            temp_stack = new int[this.state.stateStackTop + 1];
            System.arraycopy(this.state.stateStack, 0, temp_stack, 0, temp_stack.length);
            start_action_index = this.state.actionCount;
            start_token_index = this.tokStream.peek();
            error_token = this.backtrackParse(this.state.repair_token);
            ++count;
        }
        if (this.state.repair_token != 0) {
            this.state.tokens.add(this.state.repair_token);
        }
        int t = start_token_index;
        while (this.tokStream.getKind(t) != this.EOFT_SYMBOL) {
            this.state.tokens.add(t);
            t = this.tokStream.getNext(t);
        }
        this.state.tokens.add(t);
        return null;
    }

    private int process_backtrack_reductions(int act) {
        do {
            this.state.stateStackTop -= this.prs.rhs(act) - 1;
            this.trialAction(act);
            if (!this.backtrackRequested) continue;
            this.backtrackRequested = false;
            return this.ERROR_ACTION;
        } while ((act = this.prs.ntAction(this.state.stateStack[this.state.stateStackTop], this.prs.lhs(act))) <= this.NUM_RULES);
        return act;
    }

    private int process_repair_reductions(int act) {
        do {
            System.out.println("process_repair_reductions: " + act);
            this.state.stateStackTop -= this.prs.rhs(act) - 1;
        } while ((act = this.prs.ntAction(this.state.stateStack[this.state.stateStackTop], this.prs.lhs(act))) <= this.NUM_RULES);
        return act;
    }

    private int backtrackParse(int initial_token) {
        this.state.configurationStack = new ConfigurationStack(this.prs);
        this.state.trialActionStack = new LinkedList();
        this.state.trialActionStack.add(this.state.trialActionCount);
        int error_token = 0;
        int maxStackTop = this.state.stateStackTop;
        int start_token = this.tokStream.peek();
        this.state.curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(this.state.curtok);
        this.state.act = this.tAction(this.state.stateStack[this.state.stateStackTop], current_kind);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return 0;
            }
            this.state.parserLocationStack[this.state.stateStackTop] = this.state.curtok;
            if (this.state.act <= this.NUM_RULES) {
                ++this.state.actionCount;
                --this.state.stateStackTop;
                this.state.act = this.process_backtrack_reductions(this.state.act);
            } else if (this.state.act > this.ERROR_ACTION) {
                ++this.state.actionCount;
                this.state.lastToken = this.state.curtok;
                this.state.curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(this.state.curtok);
                this.state.act = this.process_backtrack_reductions(this.state.act - this.ERROR_ACTION);
            } else if (this.state.act < this.ACCEPT_ACTION) {
                ++this.state.actionCount;
                this.state.lastToken = this.state.curtok;
                this.state.curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(this.state.curtok);
            }
            if (this.state.act == this.ERROR_ACTION) {
                error_token = error_token > this.state.curtok ? error_token : this.state.curtok;
                ConfigurationElement configuration = this.state.configurationStack.pop();
                if (configuration == null) {
                    this.state.act = this.ERROR_ACTION;
                    break;
                }
                boolean shouldPop = this.prs.baseAction(configuration.conflict_index) == 0;
                this.undoActions(shouldPop);
                this.state.actionCount = configuration.action_length;
                this.state.act = configuration.act;
                this.state.curtok = configuration.curtok;
                current_kind = this.tokStream.getKind(this.state.curtok);
                this.tokStream.reset(this.state.curtok == initial_token ? start_token : this.tokStream.getNext(this.state.curtok));
                this.state.stateStackTop = configuration.stack_top;
                configuration.retrieveStack(this.state.stateStack);
                continue;
            }
            if (this.state.act > this.ACCEPT_ACTION && this.state.act != this.ERROR_ACTION) {
                if (this.state.configurationStack.findConfiguration(this.state.stateStack, this.state.stateStackTop, this.state.curtok)) {
                    this.state.act = this.ERROR_ACTION;
                    continue;
                }
                this.state.configurationStack.push(this.state.stateStack, this.state.stateStackTop, this.state.act + 1, this.state.curtok, this.state.actionCount);
                this.state.trialActionStack.add(this.state.trialActionCount);
                this.state.act = this.prs.baseAction(this.state.act);
                maxStackTop = this.state.stateStackTop > maxStackTop ? this.state.stateStackTop : maxStackTop;
                continue;
            }
            if (this.state.act == this.ACCEPT_ACTION) break;
            try {
                this.state.stateStack[++this.state.stateStackTop] = this.state.act;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.state.reallocateStateStack();
                this.state.stateStack[this.state.stateStackTop] = this.state.act;
            }
            this.state.act = this.tAction(this.state.act, current_kind);
        }
        return this.state.act == this.ERROR_ACTION ? error_token : 0;
    }

    private void backtrackParseUpToError(int initial_token, int error_token) {
        this.state.configurationStack = new ConfigurationStack(this.prs);
        this.state.trialActionStack = new LinkedList();
        this.state.trialActionStack.add(this.state.trialActionCount);
        int start_token = this.tokStream.peek();
        this.state.curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(this.state.curtok);
        this.state.act = this.tAction(this.state.stateStack[this.state.stateStackTop], current_kind);
        this.state.tokens.add(this.state.curtok);
        this.state.locationStack[this.state.stateStackTop] = this.state.tokens.size();
        this.state.actionStack[this.state.stateStackTop] = this.state.actionCount;
        this.state.undoStack[this.state.stateStackTop] = this.state.trialActionCount;
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            this.state.parserLocationStack[this.state.stateStackTop] = this.state.curtok;
            if (this.state.act <= this.NUM_RULES) {
                --this.state.stateStackTop;
                this.state.act = this.process_backtrack_reductions(this.state.act);
            } else if (this.state.act > this.ERROR_ACTION) {
                ++this.state.actionCount;
                this.state.lastToken = this.state.curtok;
                this.state.curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(this.state.curtok);
                this.state.tokens.add(this.state.curtok);
                this.state.act = this.process_backtrack_reductions(this.state.act - this.ERROR_ACTION);
            } else if (this.state.act < this.ACCEPT_ACTION) {
                ++this.state.actionCount;
                this.state.lastToken = this.state.curtok;
                this.state.curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(this.state.curtok);
                this.state.tokens.add(this.state.curtok);
            } else {
                if (this.state.act == this.ERROR_ACTION) {
                    if (this.state.curtok == error_token) break;
                    ConfigurationElement configuration = this.state.configurationStack.pop();
                    if (configuration == null) {
                        this.state.act = this.ERROR_ACTION;
                        break;
                    }
                    boolean shouldPop = this.prs.baseAction(configuration.conflict_index) == 0;
                    this.undoActions(shouldPop);
                    this.state.actionCount = configuration.action_length;
                    this.state.act = configuration.act;
                    int next_token_index = configuration.curtok;
                    this.state.tokens.reset(next_token_index);
                    this.state.curtok = this.state.tokens.get(next_token_index - 1);
                    current_kind = this.tokStream.getKind(this.state.curtok);
                    this.tokStream.reset(this.state.curtok == initial_token ? start_token : this.tokStream.getNext(this.state.curtok));
                    this.state.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.state.stateStack);
                    this.state.locationStack[this.state.stateStackTop] = this.state.tokens.size();
                    this.state.actionStack[this.state.stateStackTop] = this.state.actionCount;
                    this.state.undoStack[this.state.stateStackTop] = this.state.trialActionCount;
                    continue;
                }
                if (this.state.act <= this.ACCEPT_ACTION) break;
                if (this.state.configurationStack.findConfiguration(this.state.stateStack, this.state.stateStackTop, this.state.tokens.size())) {
                    this.state.act = this.ERROR_ACTION;
                    continue;
                }
                this.state.configurationStack.push(this.state.stateStack, this.state.stateStackTop, this.state.act + 1, this.state.tokens.size(), this.state.actionCount);
                this.state.trialActionStack.add(this.state.trialActionCount);
                this.state.act = this.prs.baseAction(this.state.act);
                continue;
            }
            this.state.stateStack[++this.state.stateStackTop] = this.state.act;
            this.state.locationStack[this.state.stateStackTop] = this.state.tokens.size();
            this.state.actionStack[this.state.stateStackTop] = ++this.state.actionCount;
            this.state.undoStack[this.state.stateStackTop] = this.state.trialActionCount;
            this.state.act = this.tAction(this.state.act, current_kind);
        }
    }

    private boolean repairable(int error_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int start_token = this.tokStream.peek();
        int final_token = this.tokStream.getStreamLength();
        int curtok = 0;
        int current_kind = this.ERROR_SYMBOL;
        int act = this.tAction(this.state.stateStack[this.state.stateStackTop], current_kind);
        while (true) {
            if (act <= this.NUM_RULES) {
                --this.state.stateStackTop;
                act = this.process_repair_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
                act = this.process_repair_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.state.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.state.stateStack);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    if (curtok == 0) {
                        current_kind = this.ERROR_SYMBOL;
                        this.tokStream.reset(start_token);
                        continue;
                    }
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(this.tokStream.getNext(curtok));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.state.stateStack, this.state.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.state.stateStack, this.state.stateStackTop, act + 1, curtok, 0);
                act = this.prs.baseAction(act);
                continue;
            }
            try {
                if (curtok > error_token && final_token == this.tokStream.getStreamLength() && this.recoverableState(act)) {
                    final_token = this.skipTokens ? curtok : this.tokStream.getNext(curtok);
                }
                this.state.stateStack[++this.state.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.state.reallocateStateStack();
                this.state.stateStack[this.state.stateStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ACCEPT_ACTION;
    }

    private boolean recoverableState(int state) {
        int k = this.prs.asi(state);
        while (this.prs.asr(k) != 0) {
            if (this.prs.asr(k) == this.ERROR_SYMBOL) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private int findRecoveryStateIndex(int start_index) {
        int i = start_index;
        while (i >= 0) {
            if (this.recoverableState(this.state.stateStack[i])) break;
            --i;
        }
        if (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                if (this.state.locationStack[k] != this.state.locationStack[i]) break;
                --k;
            }
            i = k + 1;
        }
        return i;
    }

    private int errorRepair(int recovery_token, int error_token) {
        int[] temp_stack = new int[this.state.stateStackTop + 1];
        System.arraycopy(this.state.stateStack, 0, temp_stack, 0, temp_stack.length);
        while (this.tokStream.getKind(recovery_token) != this.EOFT_SYMBOL) {
            System.out.println("recovery token: " + this.tokStream.getKind(recovery_token));
            this.tokStream.reset(recovery_token);
            if (this.repairable(error_token)) break;
            this.state.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.state.stateStack, 0, temp_stack.length);
            recovery_token = this.tokStream.getNext(recovery_token);
        }
        if (this.tokStream.getKind(recovery_token) == this.EOFT_SYMBOL) {
            this.tokStream.reset(recovery_token);
            if (!this.repairable(error_token)) {
                this.state.stateStackTop = temp_stack.length - 1;
                System.arraycopy(temp_stack, 0, this.state.stateStack, 0, temp_stack.length);
                return 0;
            }
        }
        this.state.stateStackTop = temp_stack.length - 1;
        System.arraycopy(temp_stack, 0, this.state.stateStack, 0, temp_stack.length);
        this.undoActions(this.state.undoStack[this.state.stateStackTop]);
        this.tokStream.reset(recovery_token);
        this.state.tokens.reset(this.state.locationStack[this.state.stateStackTop] - 1);
        this.state.actionCount = this.state.actionStack[this.state.stateStackTop];
        this.state.trialActionCount = this.state.undoStack[this.state.stateStackTop];
        return this.tokStream.makeErrorToken(this.state.tokens.get(this.state.locationStack[this.state.stateStackTop] - 1), this.tokStream.getPrevious(recovery_token), error_token, this.ERROR_SYMBOL);
    }

    private int tAction(int act, int sym) {
        if ((act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET) {
            int next_token = this.tokStream.peek();
            act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            while (act > this.LA_STATE_OFFSET) {
                next_token = this.tokStream.getNext(next_token);
                act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            }
        }
        return act;
    }

    private void trialAction(int action) {
        int start = this.getTokenOffset();
        int end = this.getLastToken();
        Rule rule = new Rule(action, start, end);
        this.actionProvider.setActiveRule(rule);
        boolean saveAction = this.actionProvider.trialAction(action);
        if (this.backtrackRequested) {
            return;
        }
        if (saveAction) {
            ++this.state.trialActionCount;
            this.state.pendingCommits.add(rule);
        }
    }

    private void undoActions(boolean shouldPop) {
        int oldTrialActionCount;
        if (this.state.trialActionStack.size() == 0) {
            oldTrialActionCount = 0;
        } else {
            oldTrialActionCount = this.state.trialActionStack.getLast();
            if (shouldPop) {
                this.state.trialActionStack.removeLast();
            }
        }
        this.safeUndoActions(oldTrialActionCount);
    }

    private void safeUndoActions(int total) {
        assert (total >= 0) : "Tried to go back in time but the door was already shut.";
        this.undoActions(total);
    }

    private void undoActions(int total) {
        while (this.state.trialActionCount > total) {
            Rule action = (Rule)this.state.pendingCommits.removeLast();
            this.actionProvider.setActiveRule(action);
            this.actionProvider.undoAction(action.getRuleNumber());
            --this.state.trialActionCount;
        }
    }

    public void backtrack() {
        this.backtrackRequested = true;
    }

    public void commit() {
        while (this.state.pendingCommits.size() > 0) {
            Rule activeRule = (Rule)this.state.pendingCommits.removeFirst();
            this.actionProvider.setActiveRule(activeRule);
            this.actionProvider.finalAction(activeRule.getRuleNumber());
            ++this.state.totalCommits;
        }
    }
}

