/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.macho.parser.internal;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.cdt.utils.macho.parser.internal.MachO64;

class MachOHelper64 {
    private MachO64 macho;
    private MachO64.Symbol[] dynsyms;
    private MachO64.Symbol[] symbols;
    private MachO64.Section[] sections;
    private MachO64.DyLib[] needed;
    private MachO64.DyLib[] sonames;

    public void dispose() {
        if (this.macho != null) {
            this.macho.dispose();
            this.macho = null;
        }
    }

    public boolean is64() {
        return this.macho.is64();
    }

    private void loadBinary() throws IOException {
        if (this.symbols == null) {
            this.macho.loadBinary();
            this.symbols = this.macho.getSymtabSymbols();
            this.dynsyms = this.macho.getDynamicSymbols();
            this.sections = this.macho.getSections();
            this.needed = this.macho.getDyLibs(12);
            this.sonames = this.macho.getDyLibs(13);
            if (this.dynsyms == null) {
                this.dynsyms = this.symbols;
            }
        }
    }

    public MachOHelper64(MachO64 macho) throws IOException {
        this.macho = macho;
    }

    public MachOHelper64(String filename) throws IOException {
        this.macho = new MachO64(filename);
    }

    public MachOHelper64(String filename, long offset) throws IOException {
        this.macho = new MachO64(filename, offset);
    }

    public MachOHelper64(String filename, boolean filton) throws IOException {
        this.macho = new MachO64(filename, filton);
    }

    public MachO64 getMachO() {
        return this.macho;
    }

    public MachO64.Symbol[] getExternalFunctions() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        MachO64.Symbol[] symbolArray = this.dynsyms;
        int n = this.dynsyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            MachO64.Symbol sym = symbolArray[n2];
            if ((sym.n_type_mask(16) || sym.n_type_mask(1)) && sym.n_desc(1) && (name = sym.toString()) != null && name.trim().length() > 0) {
                v.add(sym);
            }
            ++n2;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public MachO64.Symbol[] getExternalObjects() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        MachO64.Symbol[] symbolArray = this.dynsyms;
        int n = this.dynsyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            MachO64.Symbol sym = symbolArray[n2];
            if ((sym.n_type_mask(16) || sym.n_type_mask(1)) && sym.n_desc(0) && (name = sym.toString()) != null && name.trim().length() > 0) {
                v.add(sym);
            }
            ++n2;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public MachO64.Symbol[] getUndefined() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        MachO64.Symbol[] symbolArray = this.dynsyms;
        int n = this.dynsyms.length;
        int n2 = 0;
        while (n2 < n) {
            MachO64.Symbol dynsym = symbolArray[n2];
            if (dynsym.n_type(0)) {
                v.add(dynsym);
            }
            ++n2;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public MachO64.Symbol[] getLocalFunctions() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        MachO64.Symbol[] symbolArray = this.dynsyms;
        int n = this.dynsyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            MachO64.Symbol sym = symbolArray[n2];
            if (!sym.n_type_mask(16) && !sym.n_type_mask(1) && sym.n_desc(5) && (name = sym.toString()) != null && name.trim().length() > 0) {
                v.add(sym);
            }
            ++n2;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public MachO64.Symbol[] getLocalObjects() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        MachO64.Symbol[] symbolArray = this.dynsyms;
        int n = this.dynsyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            MachO64.Symbol sym = symbolArray[n2];
            if (!sym.n_type_mask(16) && !sym.n_type_mask(1) && sym.n_desc(4) && (name = sym.toString()) != null && name.trim().length() > 0) {
                v.add(sym);
            }
            ++n2;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public MachO64.Symbol[] getCommonObjects() throws IOException {
        Vector<MachO64.Symbol> v = new Vector<MachO64.Symbol>();
        this.loadBinary();
        int i = 0;
        while (i < this.dynsyms.length) {
            MachO64.Symbol sym = this.dynsyms[i];
            if (sym.n_type_mask(1) && sym.n_type(0) && sym.n_value != 0L) {
                v.add(this.symbols[i]);
            }
            ++i;
        }
        MachO64.Symbol[] ret = v.toArray(new MachO64.Symbol[0]);
        return ret;
    }

    public String[] getNeeded() throws IOException {
        Vector<String> v = new Vector<String>();
        this.loadBinary();
        MachO64.DyLib[] dyLibArray = this.needed;
        int n = this.needed.length;
        int n2 = 0;
        while (n2 < n) {
            MachO64.DyLib element = dyLibArray[n2];
            v.add(element.toString());
            ++n2;
        }
        return v.toArray(new String[0]);
    }

    public String getSoname() throws IOException {
        String soname = "";
        this.loadBinary();
        MachO64.DyLib[] dyLibArray = this.sonames;
        int n = this.sonames.length;
        int n2 = 0;
        while (n2 < n) {
            MachO64.DyLib soname2 = dyLibArray[n2];
            soname = soname2.toString();
            ++n2;
        }
        return soname;
    }

    public String getQnxUsage() throws IOException {
        return new String("");
    }

    public Sizes getSizes() throws IOException {
        long text = 0L;
        long data = 0L;
        long bss = 0L;
        this.loadBinary();
        MachO64.Section[] sectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            MachO64.Section section = sectionArray[n2];
            MachO64.SegmentCommand seg = section.segment;
            if (section.flags(255) != 1) {
                if (seg.prot(4)) {
                    text += section.size;
                } else if (!seg.prot(2)) {
                    data += section.size;
                }
            } else if (seg.prot(2)) {
                bss += section.size;
            }
            ++n2;
        }
        return new Sizes(text, data, bss);
    }

    public class Sizes {
        public long text;
        public long data;
        public long bss;
        public long total;

        public Sizes(long t, long d, long b) {
            this.text = t;
            this.data = d;
            this.bss = b;
            this.total = this.text + this.data + this.bss;
        }
    }
}

