/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.macho.parser.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.Addr64Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.macho.AR;
import org.eclipse.cdt.utils.macho.parser.internal.MachO64;
import org.eclipse.cdt.utils.macho.parser.internal.MachOHelper64;
import org.eclipse.cdt.utils.macho.parser.internal.MachOParser64;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MachOBinaryObject64
extends BinaryObjectAdapter {
    protected AR.ARHeader header;
    protected IAddressFactory addressFactory;
    protected MachO64.Attribute attributes;
    protected MachOHelper64.Sizes sizes;
    protected IBinaryParser.ISymbol[] symbols;
    protected String soname;
    protected String[] needed;
    protected long timeStamp;
    protected boolean is64 = false;
    private static final String[] NO_NEEDED = new String[0];

    public MachOBinaryObject64(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, 1);
        this.header = header;
    }

    public MachOBinaryObject64(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    @Override
    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        return new BinaryObjectAdapter.BinaryObjectInfo();
    }

    @Override
    public InputStream getContents() throws IOException {
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        return super.getContents();
    }

    protected MachOHelper64 getMachOHelper() throws IOException {
        IPath path = this.getPath();
        if (path != null) {
            if (this.header != null) {
                return new MachOHelper64(path.toOSString(), this.header.getObjectDataOffset());
            }
            return new MachOHelper64(path.toOSString());
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    @Override
    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            if (this.soname == null) {
                this.loadBinaryInfo();
            }
            this.addressFactory = this.is64 ? new Addr64Factory() : new Addr32Factory();
        }
        return this.addressFactory;
    }

    protected void clearCachedValues() {
        this.attributes = null;
        this.sizes = null;
        this.symbols = null;
        this.soname = null;
        this.needed = null;
    }

    protected MachO64.Attribute internalGetAttributes() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.attributes == null) {
            MachOHelper64 helper = null;
            try {
                try {
                    helper = this.getMachOHelper();
                    if (helper != null) {
                        this.attributes = helper.getMachO().getAttributes();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (helper != null) {
                        helper.dispose();
                    }
                }
            }
            finally {
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        return this.attributes;
    }

    protected MachOHelper64.Sizes internalGetSizes() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.sizes == null) {
            MachOHelper64 helper = null;
            try {
                try {
                    helper = this.getMachOHelper();
                    if (helper != null) {
                        this.sizes = helper.getSizes();
                        if (this.attributes == null) {
                            this.attributes = helper.getMachO().getAttributes();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (helper != null) {
                        helper.dispose();
                    }
                }
            }
            finally {
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        return this.sizes;
    }

    protected IBinaryParser.ISymbol[] internalGetSymbols() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.symbols == null) {
            this.loadBinaryInfo();
        }
        return this.symbols;
    }

    protected String internalGetSoName() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.soname == null) {
            this.loadBinaryInfo();
        }
        return this.soname;
    }

    protected String[] internalGetNeeded() {
        if (this.hasChanged()) {
            this.clearCachedValues();
        }
        if (this.needed == null) {
            this.loadBinaryInfo();
        }
        return this.needed;
    }

    protected void loadBinaryInfo() {
        MachOHelper64 helper = null;
        try {
            try {
                helper = this.getMachOHelper();
                if (helper != null) {
                    this.symbols = this.loadSymbols(helper);
                    Arrays.sort(this.symbols);
                    this.soname = helper.getSoname();
                    this.needed = helper.getNeeded();
                    this.is64 = helper.is64();
                    if (this.sizes == null) {
                        this.sizes = helper.getSizes();
                    }
                    if (this.attributes == null) {
                        this.attributes = helper.getMachO().getAttributes();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.symbols = this.NO_SYMBOLS;
                if (helper != null) {
                    helper.dispose();
                }
            }
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    protected IBinaryParser.ISymbol[] loadSymbols(MachOHelper64 helper) throws IOException {
        CPPFilt cppfilt = null;
        try {
            ArrayList<Symbol> list = new ArrayList<Symbol>();
            helper.getMachO().setCppFilter(false);
            cppfilt = this.getCPPFilt();
            this.addSymbols(helper.getExternalFunctions(), 1, cppfilt, list);
            this.addSymbols(helper.getLocalFunctions(), 1, cppfilt, list);
            this.addSymbols(helper.getExternalObjects(), 2, cppfilt, list);
            this.addSymbols(helper.getLocalObjects(), 2, cppfilt, list);
            IBinaryParser.ISymbol[] iSymbolArray = list.toArray(new IBinaryParser.ISymbol[list.size()]);
            return iSymbolArray;
        }
        finally {
            if (cppfilt != null) {
                cppfilt.dispose();
            }
        }
    }

    protected CPPFilt getCPPFilt() {
        MachOParser64 parser = (MachOParser64)this.getBinaryParser();
        return parser.getCPPFilt();
    }

    private void addSymbols(MachO64.Symbol[] array, int type, CPPFilt cppfilt, List<Symbol> list) {
        MachO64.Symbol[] symbolArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            MachO64.Symbol element = symbolArray[n2];
            String name = element.toString();
            if (cppfilt != null) {
                try {
                    name = cppfilt.getFunction(name);
                }
                catch (IOException iOException) {
                    cppfilt = null;
                }
            }
            long addr = element.n_value;
            int size = 0;
            String filename = element.getFilename();
            Path filePath = filename != null ? new Path(filename) : null;
            IAddress symbolAddr = element.is64 ? new Addr32(element.n_value) : new Addr64(BigInteger.valueOf(element.n_value));
            list.add(new Symbol(this, name, type, symbolAddr, size, (IPath)filePath, element.getLineNumber(addr), element.getLineNumber(addr + (long)size - 1L)));
            ++n2;
        }
    }

    @Override
    public String getCPU() {
        MachO64.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.getCPU();
        }
        return "";
    }

    @Override
    public boolean hasDebug() {
        MachO64.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.hasDebug();
        }
        return false;
    }

    @Override
    public boolean isLittleEndian() {
        MachO64.Attribute attribute = this.internalGetAttributes();
        if (attribute != null) {
            return attribute.isLittleEndian();
        }
        return false;
    }

    @Override
    public long getBSS() {
        MachOHelper64.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.bss;
        }
        return 0L;
    }

    @Override
    public long getData() {
        MachOHelper64.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.data;
        }
        return 0L;
    }

    @Override
    public long getText() {
        MachOHelper64.Sizes size = this.internalGetSizes();
        if (size != null) {
            return size.text;
        }
        return 0L;
    }

    @Override
    public IBinaryParser.ISymbol[] getSymbols() {
        IBinaryParser.ISymbol[] syms = this.internalGetSymbols();
        if (syms != null) {
            return syms;
        }
        return this.NO_SYMBOLS;
    }

    @Override
    public IBinaryParser.ISymbol getSymbol(IAddress addr) {
        return super.getSymbol(addr);
    }

    @Override
    public String[] getNeededSharedLibs() {
        String[] libs = this.internalGetNeeded();
        if (libs != null) {
            return libs;
        }
        return NO_NEEDED;
    }

    @Override
    public String getSoName() {
        String name = this.internalGetSoName();
        if (name != null) {
            return name;
        }
        return "";
    }

    @Override
    protected boolean hasChanged() {
        long modification;
        File file;
        IPath path = this.getPath();
        if (path != null && (file = path.toFile()) != null && (modification = file.lastModified()) != this.timeStamp) {
            this.timeStamp = modification;
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        MachO64 macho;
        if (adapter.equals(MachO64.class)) {
            try {
                return new MachO64(this.getPath().toOSString());
            }
            catch (IOException iOException) {}
        }
        if (adapter.equals(ISymbolReader.class) && (macho = (MachO64)this.getAdapter(MachO64.class)) != null) {
            return macho.getSymbolReader();
        }
        return super.getAdapter(adapter);
    }
}

