/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorageElement;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class StorableEnvironmentLoader {
    protected abstract ISerializeInfo getSerializeInfo(Object var1);

    protected StorableEnvironment loadEnvironment(Object context, boolean readOnly) {
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return null;
        }
        InputStream stream = this.loadInputStream(serializeInfo.getNode(), serializeInfo.getPrefName());
        if (stream == null) {
            return new StorableEnvironment(readOnly);
        }
        return this.loadEnvironmentFromStream(stream, readOnly);
    }

    protected void storeEnvironment(StorableEnvironment env, Object context, boolean force, boolean flush) throws CoreException {
        if (!env.isDirty() && !force) {
            return;
        }
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return;
        }
        ByteArrayOutputStream stream = this.storeEnvironmentToStream(env);
        if (stream == null) {
            return;
        }
        this.storeOutputStream(stream, serializeInfo.getNode(), serializeInfo.getPrefName(), flush);
        env.setDirty(false);
    }

    private StorableEnvironment loadEnvironmentFromStream(InputStream stream, boolean readOnly) {
        XmlStorageElement rootElement;
        block5: {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(stream);
            Document document = parser.parse(inputSource);
            Element el = document.getDocumentElement();
            rootElement = new XmlStorageElement(el);
            if ("environment".equals(rootElement.getName())) break block5;
            return null;
        }
        try {
            return new StorableEnvironment(rootElement, readOnly);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private ByteArrayOutputStream storeEnvironmentToStream(StorableEnvironment env) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element el = document.createElement("environment");
            document.appendChild(el);
            XmlStorageElement rootElement = new XmlStorageElement(el);
            env.serialize(rootElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
        }
    }

    private InputStream loadInputStream(Preferences node, String key) {
        byte[] bytes;
        if (node == null || key == null) {
            return null;
        }
        String value = node.get(key, null);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = value.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private void storeOutputStream(ByteArrayOutputStream stream, Preferences node, String key, boolean flush) throws CoreException {
        if (stream == null || node == null || key == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "StorableEnvironmentLoader.storeOutputStream.wrong.arguments", null));
        }
        byte[] bytes = stream.toByteArray();
        String val = null;
        try {
            val = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            val = new String(bytes);
        }
        node.put(key, val);
        if (flush) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, e.getMessage(), (Throwable)e));
            }
        }
    }

    public static interface ISerializeInfo {
        public Preferences getNode();

        public String getPrefName();
    }
}

