/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.IProxyCache;

public class MapProxyCache
implements IProxyCache {
    private HashMap fMap;

    private HashMap getMap(boolean create) {
        if (this.fMap == null && create) {
            this.fMap = new HashMap();
        }
        return this.fMap;
    }

    public CDataProxy[] getCachedProxies() {
        HashMap map = this.getMap(false);
        if (map != null) {
            Collection c = map.values();
            return c.toArray(new CDataProxy[c.size()]);
        }
        return new CDataProxy[0];
    }

    public CDataProxy getCachedProxy(String id) {
        HashMap map = this.getMap(false);
        if (map != null) {
            return (CDataProxy)map.get(id);
        }
        return null;
    }

    public void removeCachedProxy(String id) {
        HashMap map = this.getMap(false);
        if (map != null) {
            map.remove(id);
        }
    }

    public void clear() {
        this.fMap.clear();
    }

    public void addCachedProxy(CDataProxy proxy) {
        this.getMap(true).put(proxy.getId(), proxy);
    }

    public Map getCachedProxiesMap() {
        return (Map)this.getMap(true).clone();
    }

    public CDataProxy getCachedProxy(CDataObject data) {
        return this.getCachedProxy(data.getId());
    }

    public void removeCachedProxy(CDataProxy proxy) {
        this.removeCachedProxy(proxy.getId());
    }

    public void reuseProxies(List dataList, Map freeProxyMap) {
    }
}

