/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.util.IKindBasedInfo;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

class EntriesNamesContainer {
    private KindBasedStore fRemovedEntryNamesStore = new KindBasedStore();

    public EntriesNamesContainer() {
    }

    public EntriesNamesContainer(EntriesNamesContainer base) {
        IKindBasedInfo[] infos = base.fRemovedEntryNamesStore.getContents();
        int i = 0;
        while (i < infos.length) {
            Set set = (Set)infos[i].getInfo();
            if (set != null) {
                this.fRemovedEntryNamesStore.put(infos[i].getKind(), new HashSet(set));
            }
            ++i;
        }
    }

    private Set getRemovedNamesSet(int kind, boolean create) {
        HashSet set = (HashSet)this.fRemovedEntryNamesStore.get(kind);
        if (set == null && create) {
            set = new HashSet();
            this.fRemovedEntryNamesStore.put(kind, set);
        }
        return set;
    }

    public void clear() {
        this.fRemovedEntryNamesStore.clear();
    }

    public void clear(int kind) {
        this.fRemovedEntryNamesStore.put(kind, null);
    }

    public boolean contains(int kind, String name) {
        Set set = this.getRemovedNamesSet(kind, false);
        if (set != null) {
            return set.contains(name);
        }
        return false;
    }

    public boolean add(int kind, String name) {
        return this.getRemovedNamesSet(kind, true).add(name);
    }

    public boolean remove(int kind, String name) {
        Set set = this.getRemovedNamesSet(kind, false);
        if (set != null) {
            return set.remove(name);
        }
        return false;
    }

    public void set(int kind, String[] names) {
        if (names == null || names.length == 0) {
            this.clear(kind);
        } else {
            Set set = this.getRemovedNamesSet(kind, true);
            set.clear();
            EntriesNamesContainer.add(set, names);
        }
    }

    private static void add(Set set, String[] names) {
        int i = 0;
        while (i < names.length) {
            set.add(names[i]);
            ++i;
        }
    }

    public void add(int kind, String[] names) {
        if (names == null || names.length == 0) {
            return;
        }
        Set set = this.getRemovedNamesSet(kind, true);
        EntriesNamesContainer.add(set, names);
    }
}

