/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCEnumeration
extends PDOMBinding
implements IEnumeration,
IIndexType {
    private static final int FIRST_ENUMERATOR = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCEnumeration(PDOMLinkage linkage, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumeration.getNameCharArray());
    }

    public PDOMCEnumeration(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 10;
    }

    public IEnumerator[] getEnumerators() throws DOMException {
        try {
            ArrayList<PDOMCEnumerator> enums = new ArrayList<PDOMCEnumerator>();
            PDOMCEnumerator enumerator = this.getFirstEnumerator();
            while (enumerator != null) {
                enums.add(enumerator);
                enumerator = enumerator.getNextEnumerator();
            }
            Collections.reverse(enums);
            return enums.toArray(new IEnumerator[enums.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IEnumerator[0];
        }
    }

    private PDOMCEnumerator getFirstEnumerator() throws CoreException {
        long value = this.getDB().getRecPtr(this.record + 28L);
        return value != 0L ? new PDOMCEnumerator((PDOMLinkage)this.getLinkage(), value) : null;
    }

    public void addEnumerator(PDOMCEnumerator enumerator) throws CoreException {
        PDOMCEnumerator first = this.getFirstEnumerator();
        enumerator.setNextEnumerator(first);
        this.getDB().putRecPtr(this.record + 28L, enumerator.getRecord());
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof IEnumeration) {
            IEnumeration etype = (IEnumeration)type;
            etype = (IEnumeration)PDOMASTAdapter.getAdapterForAnonymousASTBinding(etype);
            try {
                return this.getDBName().equals(etype.getNameCharArray());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

