/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.pdom.Checksums;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMImportOperation;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMProjectIndexLocationConverter;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamPDOMExportOperation
implements IWorkspaceRunnable {
    private ICProject fProject;
    private String fTargetLocation;
    private File fTargetLocationFile;
    private MessageDigest fMessageDigest;

    public TeamPDOMExportOperation(ICProject project) {
        this.fProject = project;
    }

    public void setTargetLocation(String location) {
        this.fTargetLocation = location;
    }

    public void setOptions(int options) {
    }

    public void setAlgorithm(MessageDigest md) {
        this.fMessageDigest = md;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.getMessageDigest();
        this.getTargetLocation();
        File tmpPDOM = null;
        File tmpChecksums = null;
        try {
            tmpPDOM = File.createTempFile("tmp", ".pdom");
            tmpChecksums = File.createTempFile("checksums", ".dat");
        }
        catch (IOException e) {
            throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorCreatingTempFile, e));
        }
        try {
            try {
                PDOMManager pdomManager = CCoreInternals.getPDOMManager();
                monitor.beginTask("", 100);
                pdomManager.joinIndexer(Integer.MAX_VALUE, (IProgressMonitor)this.subMonitor(monitor, 1));
                this.checkMonitor(monitor);
                PDOMProjectIndexLocationConverter converter = new PDOMProjectIndexLocationConverter(this.fProject.getProject(), true);
                pdomManager.exportProjectPDOM(this.fProject, tmpPDOM, converter);
                this.checkMonitor(monitor);
                monitor.worked(5);
                PDOM pdom = new PDOM(tmpPDOM, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                pdom.acquireReadLock();
                try {
                    monitor.setTaskName(Messages.Checksums_taskComputeChecksums);
                    this.createChecksums(this.fProject, pdom, tmpChecksums, (IProgressMonitor)this.subMonitor(monitor, 94));
                    pdom.db.setExclusiveLock();
                    pdom.close();
                }
                finally {
                    pdom.releaseReadLock();
                }
                this.createArchive(tmpPDOM, tmpChecksums);
                monitor.setTaskName(Messages.TeamPDOMExportOperation_taskExportIndex);
                IndexerPreferences.setIndexImportLocation(this.fProject.getProject(), this.fTargetLocation.toString());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                if (tmpPDOM != null) {
                    tmpPDOM.delete();
                }
                if (tmpChecksums != null) {
                    tmpChecksums.delete();
                }
                return;
            }
        }
        finally {
            if (tmpPDOM != null) {
                tmpPDOM.delete();
            }
            if (tmpChecksums != null) {
                tmpChecksums.delete();
            }
        }
    }

    private void getTargetLocation() throws CoreException {
        this.fTargetLocationFile = TeamPDOMImportOperation.expandLocation(this.fProject.getProject(), this.fTargetLocation);
    }

    private void getMessageDigest() throws CoreException {
        if (this.fMessageDigest == null) {
            try {
                this.fMessageDigest = Checksums.getDefaultAlgorithm();
            }
            catch (NoSuchAlgorithmException e) {
                throw new CoreException(CCorePlugin.createStatus(e.getMessage(), e));
            }
        }
    }

    private void createChecksums(ICProject cproject, PDOM pdom, File target, IProgressMonitor monitor) throws CoreException {
        HashSet<String> fullPaths = new HashSet<String>();
        try {
            pdom.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        try {
            IIndexFragmentFile[] ifiles = pdom.getAllFiles();
            int i = 0;
            while (i < ifiles.length) {
                String fullPath = ifiles[i].getLocation().getFullPath();
                if (fullPath != null) {
                    fullPaths.add(fullPath);
                }
                ++i;
            }
        }
        finally {
            pdom.releaseReadLock();
        }
        int i = 0;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = new IFile[fullPaths.size()];
        for (String fullPath : fullPaths) {
            files[i++] = root.getFile((IPath)new Path(fullPath));
        }
        Map<String, Object> map = Checksums.createChecksumMap(files, this.fMessageDigest, monitor);
        this.writeChecksums(map, target);
    }

    private void writeChecksums(Map<?, ?> map, File target) throws CoreException {
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new FileOutputStream(target));
                out.writeObject(map);
            }
            catch (IOException e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorWriteTempFile, e));
            }
        }
        catch (Throwable throwable) {
            this.close(out);
            throw throwable;
        }
        this.close(out);
    }

    private void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    private void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    private void createArchive(File tmpPDOM, File tmpChecksums) throws CoreException {
        this.fTargetLocationFile.delete();
        ZipOutputStream out = null;
        try {
            try {
                this.fTargetLocationFile.getParentFile().mkdirs();
                out = new ZipOutputStream(new FileOutputStream(this.fTargetLocationFile));
                out.setLevel(9);
                this.writeEntry(out, "cdt-index.pdom", tmpPDOM);
                this.writeEntry(out, "checksums.dat", tmpChecksums);
            }
            catch (IOException e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorCreateArchive, e));
            }
        }
        catch (Throwable throwable) {
            this.close(out);
            throw throwable;
        }
        this.close(out);
        IFile[] wsResource = ResourceLookup.findFilesForLocation((IPath)new Path(this.fTargetLocationFile.getAbsolutePath()));
        int i = 0;
        while (i < wsResource.length) {
            IFile file = wsResource[i];
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
    }

    private void writeEntry(ZipOutputStream out, String name, File input) throws IOException {
        ZipEntry e = new ZipEntry(name);
        out.putNextEntry(e);
        int read = 0;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(input);
        try {
            while ((read = ((InputStream)in).read(buffer)) >= 0) {
                out.write(buffer, 0, read);
            }
            out.closeEntry();
        }
        finally {
            this.close(in);
        }
    }

    private SubProgressMonitor subMonitor(IProgressMonitor monitor, int ticks) {
        return new SubProgressMonitor(monitor, ticks);
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

