/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.ext.CElementHandle;

public class MethodDeclarationHandle
extends CElementHandle
implements IMethodDeclaration {
    private String[] fParameterTypes;
    private ASTAccessVisibility fVisibility;
    private boolean fIsStatic;
    private boolean fIsConstructor;
    private boolean fIsDestructor;

    public MethodDeclarationHandle(ICElement parent, ICPPMethod method) throws DOMException {
        this(parent, 71, method);
    }

    protected MethodDeclarationHandle(ICElement parent, int type, ICPPMethod method) throws DOMException {
        super(parent, type, method.getName());
        this.fParameterTypes = this.extractParameterTypes(method);
        this.fVisibility = this.getVisibility(method);
        try {
            this.fIsStatic = method.isStatic();
            this.fIsConstructor = method instanceof ICPPConstructor;
            if (!this.fIsConstructor) {
                this.fIsDestructor = method.isDestructor();
            }
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMethodDeclaration) {
            return MethodDeclaration.equals(this, (IMethodDeclaration)obj);
        }
        return false;
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes.length;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getSignature() throws CModelException {
        return FunctionDeclaration.getSignature(this);
    }

    public boolean isStatic() throws CModelException {
        return this.fIsStatic;
    }

    public ASTAccessVisibility getVisibility() throws CModelException {
        return this.fVisibility;
    }

    public boolean isConstructor() throws CModelException {
        return this.fIsConstructor;
    }

    public boolean isDestructor() throws CModelException {
        return this.fIsDestructor;
    }
}

