/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCommentMap {
    protected final HashMap<IASTNode, ArrayList<IASTComment>> leadingMap = new HashMap();
    protected final HashMap<IASTNode, ArrayList<IASTComment>> trailingMap = new HashMap();
    protected final HashMap<IASTNode, ArrayList<IASTComment>> freestandingMap = new HashMap();

    public void addTrailingCommentToNode(IASTNode node, IASTComment comment) {
        ArrayList<IASTComment> comments = this.trailingMap.get(node);
        if (comments == null) {
            comments = new ArrayList();
        }
        comments.add(comment);
        this.trailingMap.put(node, comments);
    }

    public ArrayList<IASTComment> getTrailingCommentsForNode(IASTNode node) {
        if (this.trailingMap.get(node) == null) {
            return new ArrayList<IASTComment>();
        }
        return this.trailingMap.get(node);
    }

    public void addLeadingCommentToNode(IASTNode node, IASTComment comment) {
        ArrayList<IASTComment> comments = this.leadingMap.get(node);
        if (comments == null) {
            comments = new ArrayList();
        }
        comments.add(comment);
        this.leadingMap.put(node, comments);
    }

    public ArrayList<IASTComment> getLeadingCommentsForNode(IASTNode node) {
        if (this.leadingMap.get(node) == null) {
            return new ArrayList<IASTComment>();
        }
        return this.leadingMap.get(node);
    }

    public void addFreestandingCommentToNode(IASTNode node, IASTComment comment) {
        ArrayList<IASTComment> comments = this.freestandingMap.get(node);
        if (comments == null) {
            comments = new ArrayList();
        }
        comments.add(comment);
        this.freestandingMap.put(node, comments);
    }

    public ArrayList<IASTComment> getFreestandingCommentsForNode(IASTNode node) {
        if (this.freestandingMap.get(node) == null) {
            return new ArrayList<IASTComment>();
        }
        return this.freestandingMap.get(node);
    }

    public HashMap<IASTNode, ArrayList<IASTComment>> getLeadingMap() {
        return this.leadingMap;
    }

    public HashMap<IASTNode, ArrayList<IASTComment>> getTrailingMap() {
        return this.trailingMap;
    }

    public HashMap<IASTNode, ArrayList<IASTComment>> getFreestandingMap() {
        return this.freestandingMap;
    }

    public ArrayList<IASTComment> getAllCommentsForNode(IASTNode node) {
        ArrayList<IASTComment> comment = new ArrayList<IASTComment>();
        comment.addAll(this.getFreestandingCommentsForNode(node));
        comment.addAll(this.getLeadingCommentsForNode(node));
        comment.addAll(this.getTrailingCommentsForNode(node));
        return comment;
    }
}

