/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionSpecialization
extends CPPSpecialization
implements ICPPFunction,
ICPPInternalFunction {
    private ICPPFunctionType type = null;
    private IParameter[] specializedParams = null;
    private IType[] specializedExceptionSpec = null;

    public CPPFunctionSpecialization(IBinding orig, IBinding owner, ICPPTemplateParameterMap argMap) {
        super(orig, owner, argMap);
    }

    private ICPPFunction getFunction() {
        return (ICPPFunction)this.getSpecializedBinding();
    }

    public IParameter[] getParameters() throws DOMException {
        if (this.specializedParams == null) {
            ICPPFunction function = (ICPPFunction)this.getSpecializedBinding();
            IParameter[] params = function.getParameters();
            this.specializedParams = new IParameter[params.length];
            int i = 0;
            while (i < params.length) {
                this.specializedParams[i] = new CPPParameterSpecialization((ICPPParameter)params[i], (IBinding)this, this.getTemplateParameterMap());
                ++i;
            }
        }
        return this.specializedParams;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public ICPPFunctionType getType() throws DOMException {
        if (this.type == null) {
            ICPPFunction function = (ICPPFunction)this.getSpecializedBinding();
            this.type = (ICPPFunctionType)this.specializeType(function.getType());
        }
        return this.type;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isInline() throws DOMException {
        if (this.getDefinition() != null) {
            IASTNode def = this.getDefinition();
            while (!(def instanceof IASTFunctionDefinition)) {
                def = def.getParent();
            }
            return ((IASTFunctionDefinition)def).getDeclSpecifier().isInline();
        }
        return this.getFunction().isInline();
    }

    public boolean isExternC() throws DOMException {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        return this.getFunction().isExternC();
    }

    public boolean isStatic() {
        return this.isStatic(true);
    }

    public boolean isStatic(boolean resolveAll) {
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)f).isStatic(resolveAll);
        }
        if (f instanceof IIndexBinding && f instanceof ICPPFunction) {
            try {
                return ((ICPPFunction)f).isStatic();
            }
            catch (DOMException dOMException) {}
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    public boolean isExtern() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isExtern();
        }
        return CPPFunction.hasStorageClass(this, 2);
    }

    public boolean isAuto() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isAuto();
        }
        return CPPFunction.hasStorageClass(this, 4);
    }

    public boolean isRegister() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isRegister();
        }
        return CPPFunction.hasStorageClass(this, 5);
    }

    public boolean takesVarArgs() throws DOMException {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.takesVarArgs();
        }
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        if (dtor != null) {
            return dtor.takesVarArgs();
        }
        ICPPASTFunctionDeclarator[] ds = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        if (ds != null && ds.length > 0) {
            return ds[0].takesVarArgs();
        }
        return false;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTDeclarator dtor = param.getDeclarator();
        while (dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
        }
        IASTName name = dtor.getName();
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        try {
            IParameter[] params = this.getParameters();
            if (i < params.length) {
                IParameter myParam = params[i];
                name.setBinding(myParam);
                ASTInternal.addDeclaration(myParam, name);
                return myParam;
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }

    public void addDefinition(IASTNode node) {
        IASTNode n = node;
        while (n instanceof IASTName) {
            n = n.getParent();
        }
        if (!(n instanceof ICPPASTFunctionDeclarator)) {
            return;
        }
        this.updateParameterBindings((ICPPASTFunctionDeclarator)n);
        super.addDefinition(n);
    }

    public void addDeclaration(IASTNode node) {
        IASTNode n = node;
        while (n instanceof IASTName) {
            n = n.getParent();
        }
        if (!(n instanceof ICPPASTFunctionDeclarator)) {
            return;
        }
        this.updateParameterBindings((ICPPASTFunctionDeclarator)n);
        super.addDeclaration(n);
    }

    protected void updateParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        IParameter[] params = null;
        try {
            params = this.getParameters();
        }
        catch (DOMException dOMException) {
            return;
        }
        IASTParameterDeclaration[] nps = fdtor.getParameters();
        int i = 0;
        while (i < nps.length) {
            IParameter param = params[i];
            if (param != null) {
                IASTDeclarator dtor = nps[i].getDeclarator();
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                IASTName name = dtor.getName();
                name.setBinding(param);
                ASTInternal.addDeclaration(param, name);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = null;
        try {
            t = this.getType();
        }
        catch (DOMException dOMException) {}
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        ICPPTemplateParameterMap tpmap = this.getTemplateParameterMap();
        if (tpmap != null) {
            result.append(" ");
            result.append(tpmap.toString());
        }
        return result.toString();
    }

    public IType[] getExceptionSpecification() throws DOMException {
        ICPPFunction function;
        IType[] types;
        if (this.specializedExceptionSpec == null && (types = (function = (ICPPFunction)this.getSpecializedBinding()).getExceptionSpecification()) != null) {
            IType[] specializedTypeList = new IType[types.length];
            int i = 0;
            while (i < types.length) {
                specializedTypeList[i] = this.specializeType(types[i]);
                ++i;
            }
        }
        return this.specializedExceptionSpec;
    }
}

