/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTWhileStatement
extends ASTNode
implements ICPPASTWhileStatement,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTStatement body;
    private IASTDeclaration condition2;
    private IScope scope;

    public CPPASTWhileStatement() {
    }

    public CPPASTWhileStatement(IASTDeclaration condition, IASTStatement body) {
        this.setConditionDeclaration(condition);
        this.setBody(body);
    }

    public CPPASTWhileStatement(IASTExpression condition, IASTStatement body) {
        this.setCondition(condition);
        this.setBody(body);
    }

    public CPPASTWhileStatement copy() {
        CPPASTWhileStatement copy = new CPPASTWhileStatement();
        copy.setConditionDeclaration(this.condition2 == null ? null : this.condition2.copy());
        copy.setCondition(this.condition == null ? null : this.condition.copy());
        copy.setBody(this.body == null ? null : this.body.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getCondition() {
        return this.condition;
    }

    public void setCondition(IASTExpression condition) {
        this.assertNotFrozen();
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITIONEXPRESSION);
            this.condition2 = null;
        }
    }

    public IASTStatement getBody() {
        return this.body;
    }

    public void setBody(IASTStatement body) {
        this.assertNotFrozen();
        this.body = body;
        if (body != null) {
            body.setParent(this);
            body.setPropertyInParent(BODY);
        }
    }

    public IASTDeclaration getConditionDeclaration() {
        return this.condition2;
    }

    public void setConditionDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.condition2 = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(CONDITIONDECLARATION);
            this.condition = null;
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.condition2 != null && !this.condition2.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        }
        if (child == this.condition || child == this.condition2) {
            if (other instanceof IASTExpression) {
                this.setCondition((IASTExpression)other);
            } else if (other instanceof IASTDeclaration) {
                this.setConditionDeclaration((IASTDeclaration)other);
            }
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }
}

