/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;

public class CPPASTFunctionWithTryBlock
extends CPPASTFunctionDefinition
implements ICPPASTFunctionWithTryBlock {
    private ICPPASTCatchHandler[] catchHandlers = null;
    private int catchHandlersPos = -1;

    public CPPASTFunctionWithTryBlock() {
    }

    public CPPASTFunctionWithTryBlock(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, IASTStatement bodyStatement) {
        super(declSpecifier, declarator, bodyStatement);
    }

    public CPPASTFunctionWithTryBlock copy() {
        IASTDeclSpecifier declSpecifier = this.getDeclSpecifier();
        IASTFunctionDeclarator declarator = this.getDeclarator();
        IASTStatement bodyStatement = this.getBody();
        CPPASTFunctionWithTryBlock copy = new CPPASTFunctionWithTryBlock();
        copy.setDeclSpecifier(declSpecifier == null ? null : declSpecifier.copy());
        copy.setDeclarator(declarator == null ? null : declarator.copy());
        copy.setBody(bodyStatement == null ? null : bodyStatement.copy());
        IASTNode[] iASTNodeArray = this.getMemberInitializers();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTConstructorChainInitializer initializer = iASTNodeArray[n2];
            copy.addMemberInitializer(initializer == null ? null : initializer.copy());
            ++n2;
        }
        iASTNodeArray = this.getCatchHandlers();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode handler = iASTNodeArray[n2];
            copy.addCatchHandler(handler == null ? null : handler.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void addCatchHandler(ICPPASTCatchHandler statement) {
        this.assertNotFrozen();
        if (statement != null) {
            this.catchHandlers = (ICPPASTCatchHandler[])ArrayUtil.append(ICPPASTCatchHandler.class, this.catchHandlers, ++this.catchHandlersPos, statement);
            statement.setParent(this);
            statement.setPropertyInParent(CATCH_HANDLER);
        }
    }

    public ICPPASTCatchHandler[] getCatchHandlers() {
        if (this.catchHandlers == null) {
            return ICPPASTCatchHandler.EMPTY_CATCHHANDLER_ARRAY;
        }
        this.catchHandlers = (ICPPASTCatchHandler[])ArrayUtil.removeNullsAfter(ICPPASTCatchHandler.class, this.catchHandlers, this.catchHandlersPos);
        return this.catchHandlers;
    }

    protected boolean acceptCatchHandlers(ASTVisitor action) {
        ICPPASTCatchHandler[] handlers = this.getCatchHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (!handlers[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

