/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPASTFunctionDeclarator
extends CPPASTDeclarator
implements ICPPASTFunctionDeclarator {
    private IASTParameterDeclaration[] parameters = null;
    private int parametersPos = -1;
    private IASTTypeId[] typeIds = NO_EXCEPTION_SPECIFICATION;
    private int typeIdsPos = -1;
    private boolean varArgs;
    private boolean pureVirtual;
    private boolean isVolatile;
    private boolean isConst;
    private ICPPFunctionScope scope = null;

    public CPPASTFunctionDeclarator() {
    }

    public CPPASTFunctionDeclarator(IASTName name) {
        super(name);
    }

    public CPPASTFunctionDeclarator copy() {
        CPPASTFunctionDeclarator copy = new CPPASTFunctionDeclarator();
        this.copyBaseDeclarator(copy);
        copy.varArgs = this.varArgs;
        copy.pureVirtual = this.pureVirtual;
        copy.isVolatile = this.isVolatile;
        copy.isConst = this.isConst;
        IASTNode[] iASTNodeArray = this.getParameters();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTParameterDeclaration param = iASTNodeArray[n2];
            copy.addParameterDeclaration(param == null ? null : param.copy());
            ++n2;
        }
        iASTNodeArray = this.getExceptionSpecification();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode typeId = iASTNodeArray[n2];
            copy.addExceptionSpecificationTypeId(typeId == null ? null : typeId.copy());
            ++n2;
        }
        return copy;
    }

    public IASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return IASTParameterDeclaration.EMPTY_PARAMETERDECLARATION_ARRAY;
        }
        this.parameters = ArrayUtil.trimAt(IASTParameterDeclaration.class, this.parameters, this.parametersPos);
        return this.parameters;
    }

    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        this.assertNotFrozen();
        if (parameter != null) {
            parameter.setParent(this);
            parameter.setPropertyInParent(FUNCTION_PARAMETER);
            this.parameters = (IASTParameterDeclaration[])ArrayUtil.append(IASTParameterDeclaration.class, this.parameters, ++this.parametersPos, parameter);
        }
    }

    public boolean takesVarArgs() {
        return this.varArgs;
    }

    public void setVarArgs(boolean value) {
        this.assertNotFrozen();
        this.varArgs = value;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    public IASTTypeId[] getExceptionSpecification() {
        this.typeIds = ArrayUtil.trimAt(IASTTypeId.class, this.typeIds, this.typeIdsPos);
        return this.typeIds;
    }

    public void setEmptyExceptionSpecification() {
        this.assertNotFrozen();
        this.typeIds = IASTTypeId.EMPTY_TYPEID_ARRAY;
    }

    public void addExceptionSpecificationTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        if (typeId != null) {
            this.typeIds = (IASTTypeId[])ArrayUtil.append(IASTTypeId.class, this.typeIds, ++this.typeIdsPos, typeId);
            typeId.setParent(this);
            typeId.setPropertyInParent(EXCEPTION_TYPEID);
        }
    }

    public boolean isPureVirtual() {
        return this.pureVirtual;
    }

    public void setPureVirtual(boolean isPureVirtual) {
        this.assertNotFrozen();
        this.pureVirtual = isPureVirtual;
    }

    @Deprecated
    public ICPPASTConstructorChainInitializer[] getConstructorChain() {
        if (CPPVisitor.findTypeRelevantDeclarator(this) == this) {
            IASTNode parent = this.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                if (parent == null) break;
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTFunctionDefinition) {
                return ((ICPPASTFunctionDefinition)parent).getMemberInitializers();
            }
        }
        return ICPPASTConstructorChainInitializer.EMPTY_CONSTRUCTORCHAININITIALIZER_ARRAY;
    }

    @Deprecated
    public void addConstructorToChain(ICPPASTConstructorChainInitializer initializer) {
        this.assertNotFrozen();
    }

    public ICPPFunctionScope getFunctionScope() {
        if (this.scope != null) {
            return this.scope;
        }
        IASTNode node = this.getParent();
        while (!(node instanceof IASTDeclaration)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            return null;
        }
        if (CPPVisitor.findTypeRelevantDeclarator(this) == this) {
            this.scope = new CPPFunctionScope(this);
        }
        return this.scope;
    }

    protected boolean postAccept(ASTVisitor action) {
        IASTParameterDeclaration[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTTypeId[] ids = this.getExceptionSpecification();
        int i2 = 0;
        while (i2 < ids.length) {
            if (!ids[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        return super.postAccept(action);
    }
}

