/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTFunctionCallExpression
extends ASTNode
implements ICPPASTFunctionCallExpression,
IASTAmbiguityParent {
    private IASTExpression functionName;
    private IASTExpression parameter;
    private IASTImplicitName[] implicitNames = null;
    private IType type;
    private ICPPFunction overload = UNINITIALIZED_FUNCTION;

    public CPPASTFunctionCallExpression() {
    }

    public CPPASTFunctionCallExpression(IASTExpression functionName, IASTExpression parameter) {
        this.setFunctionNameExpression(functionName);
        this.setParameterExpression(parameter);
    }

    public CPPASTFunctionCallExpression copy() {
        CPPASTFunctionCallExpression copy = new CPPASTFunctionCallExpression();
        copy.setFunctionNameExpression(this.functionName == null ? null : this.functionName.copy());
        copy.setParameterExpression(this.parameter == null ? null : this.parameter.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public void setFunctionNameExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.functionName = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FUNCTION_NAME);
        }
    }

    public IASTExpression getFunctionNameExpression() {
        return this.functionName;
    }

    public void setParameterExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.parameter = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(PARAMETERS);
        }
    }

    public IASTExpression getParameterExpression() {
        return this.parameter;
    }

    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            CPPASTImplicitName n2;
            CPPASTImplicitName n1;
            block9: {
                ICPPFunction overload = this.getOperator();
                if (overload == null) {
                    this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                    return IASTImplicitName.EMPTY_NAME_ARRAY;
                }
                n1 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n1.setBinding(overload);
                n2 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n2.setBinding(overload);
                n2.setAlternate(true);
                if (this.parameter == null) {
                    int idEndOffset = ((ASTNode)((Object)this.functionName)).getOffset() + ((ASTNode)((Object)this.functionName)).getLength();
                    try {
                        IToken lparen = this.functionName.getTrailingSyntax();
                        IToken rparen = lparen.getNext();
                        if (lparen.getType() == 8) {
                            n1.setOffsetAndLength(idEndOffset + lparen.getOffset(), 1);
                        } else {
                            n1.setOffsetAndLength(idEndOffset + lparen.getEndOffset(), 0);
                        }
                        if (rparen.getType() == 9) {
                            n2.setOffsetAndLength(idEndOffset + rparen.getOffset(), 1);
                            break block9;
                        }
                        n2.setOffsetAndLength(idEndOffset + rparen.getEndOffset(), 0);
                    }
                    catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                        n1.setOffsetAndLength(idEndOffset, 0);
                        n2.setOffsetAndLength(idEndOffset, 0);
                    }
                } else {
                    n1.computeOperatorOffsets(this.functionName, true);
                    n2.computeOperatorOffsets(this.parameter, true);
                }
            }
            this.implicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.implicitNames;
    }

    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.functionName != null && !this.functionName.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(action)) {
            return false;
        }
        if (implicits != null && implicits.length > 0 && !implicits[1].accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.functionName) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.functionName = (IASTExpression)other;
        }
        if (child == this.parameter) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.parameter = (IASTExpression)other;
        }
    }

    public ICPPFunction getOperator() {
        if (this.overload == UNINITIALIZED_FUNCTION) {
            this.overload = null;
            this.getExpressionType();
        }
        return this.overload;
    }

    public IType getExpressionType() {
        if (this.type == null) {
            this.type = this.computeExpressionType();
        }
        return this.type;
    }

    private IType computeExpressionType() {
        this.overload = null;
        try {
            IType t = null;
            if (this.functionName instanceof IASTIdExpression) {
                IBinding binding = ((IASTIdExpression)this.functionName).getName().resolvePreBinding();
                if (binding instanceof ICPPConstructor) {
                    IBinding owner = binding.getOwner();
                    if (owner instanceof ICPPClassType) {
                        return (ICPPClassType)owner;
                    }
                    return new ProblemBinding(this, 10, binding.getName().toCharArray());
                }
                if (binding instanceof IFunction) {
                    t = ((IFunction)binding).getType();
                } else if (binding instanceof IVariable) {
                    t = ((IVariable)binding).getType();
                } else {
                    if (binding instanceof IType) {
                        return (IType)((Object)binding);
                    }
                    if (binding instanceof IProblemBinding) {
                        return (IProblemBinding)binding;
                    }
                }
            } else {
                t = this.functionName.getExpressionType();
            }
            t = SemanticUtil.getUltimateTypeUptoPointers(t);
            if (t instanceof IFunctionType) {
                return ((IFunctionType)t).getReturnType();
            }
            if (t instanceof ICPPClassType) {
                ICPPFunction op = CPPSemantics.findOverloadedOperator(this, (ICPPClassType)t);
                if (op != null) {
                    this.overload = op;
                    return op.getType().getReturnType();
                }
            } else if (t instanceof IPointerType && (t = SemanticUtil.getUltimateTypeUptoPointers(((IPointerType)t).getType())) instanceof IFunctionType) {
                return ((IFunctionType)t).getReturnType();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }
}

