/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.CharArrayMap;

public class CStructMapper {
    private final IASTTranslationUnit fTranslationUnit;
    protected CharArrayMap<IASTName> fStructs;

    public CStructMapper(IASTTranslationUnit tu) {
        this.fTranslationUnit = tu;
    }

    public IType mapToAST(ICompositeType type) {
        ICompositeType mapped;
        IBinding b;
        IASTName name;
        if (this.fStructs == null) {
            this.fStructs = new CharArrayMap();
            this.fTranslationUnit.accept(new Visitor());
        }
        if ((name = this.fStructs.get(type.getNameCharArray())) != null && (b = name.resolveBinding()) instanceof ICompositeType && (mapped = (ICompositeType)b).isSameType(type)) {
            return mapped;
        }
        return type;
    }

    private class Visitor
    extends ASTVisitor {
        Visitor() {
            this.shouldVisitDeclarations = true;
        }

        public int visit(IASTDeclaration declaration) {
            IASTDeclSpecifier declspec;
            if (declaration instanceof IASTSimpleDeclaration && (declspec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTCompositeTypeSpecifier) {
                IASTCompositeTypeSpecifier cts = (IASTCompositeTypeSpecifier)declspec;
                IASTName name = cts.getName();
                char[] nameChars = name.toCharArray();
                if (nameChars.length > 0) {
                    CStructMapper.this.fStructs.put(nameChars, name);
                }
                return 3;
            }
            return 1;
        }
    }
}

