/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CParameter
extends PlatformObject
implements IParameter {
    private IASTName[] declarations;
    private IType type = null;

    public CParameter(IASTName parameterName) {
        this.declarations = new IASTName[]{parameterName};
    }

    public IType getType() {
        if (this.type == null && this.declarations[0].getParent() instanceof IASTDeclarator) {
            this.type = CVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    private IASTName getPrimaryDeclaration() {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length && this.declarations[i] != null) {
                IASTNode node = this.declarations[i].getParent();
                while (!(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                if (node.getPropertyInParent() == ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER || node instanceof IASTFunctionDefinition) {
                    return this.declarations[i];
                }
                ++i;
            }
            return this.declarations[0];
        }
        return null;
    }

    public String getName() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.toString();
        }
        return "";
    }

    public char[] getNameCharArray() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.toCharArray();
        }
        return CVisitor.EMPTY_CHAR_ARRAY;
    }

    public IScope getScope() {
        int i = 0;
        while (i < this.declarations.length) {
            IASTFunctionDeclarator fdtor;
            IASTNode parent = this.declarations[i].getParent();
            if (parent instanceof ICASTKnRFunctionDeclarator) {
                parent = parent.getParent();
                return ((IASTCompoundStatement)((IASTFunctionDefinition)parent).getBody()).getScope();
            }
            IASTNode fdtorNode = parent.getParent().getParent();
            if (fdtorNode instanceof IASTFunctionDeclarator && (parent = (fdtor = (IASTFunctionDeclarator)fdtorNode).getParent()) instanceof IASTFunctionDefinition) {
                return ((IASTCompoundStatement)((IASTFunctionDefinition)parent).getBody()).getScope();
            }
            ++i;
        }
        return null;
    }

    public void addDeclaration(IASTName name) {
        if (name != null && name.isActive()) {
            this.declarations = (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name);
        }
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        if (this.declarations == null) {
            return false;
        }
        int i = 0;
        while (i < this.declarations.length && this.declarations[i] != null) {
            IASTNode parent = this.declarations[i].getParent();
            while (!(parent instanceof IASTParameterDeclaration) && !(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTParameterDeclaration) {
                declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier();
            }
            if (declSpec != null) {
                return declSpec.getStorageClass() == storage;
            }
            ++i;
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    public IBinding getOwner() throws DOMException {
        if (this.declarations == null || this.declarations.length == 0) {
            return null;
        }
        return CVisitor.findEnclosingFunction(this.declarations[0]);
    }

    public IValue getInitialValue() {
        return null;
    }

    public static class CParameterProblem
    extends ProblemBinding
    implements IParameter {
        public CParameterProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public IValue getInitialValue() {
            return null;
        }
    }
}

