/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTWhileStatement
extends ASTNode
implements IASTWhileStatement,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTStatement body;

    public CASTWhileStatement() {
    }

    public CASTWhileStatement(IASTExpression condition, IASTStatement body) {
        this.setCondition(condition);
        this.setBody(body);
    }

    public CASTWhileStatement copy() {
        CASTWhileStatement copy = new CASTWhileStatement();
        copy.setCondition(this.condition == null ? null : this.condition.copy());
        copy.setBody(this.body == null ? null : this.body.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getCondition() {
        return this.condition;
    }

    public void setCondition(IASTExpression condition) {
        this.assertNotFrozen();
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITIONEXPRESSION);
        }
    }

    public IASTStatement getBody() {
        return this.body;
    }

    public void setBody(IASTStatement body) {
        this.assertNotFrozen();
        this.body = body;
        if (body != null) {
            body.setParent(this);
            body.setPropertyInParent(BODY);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        }
        if (child == this.condition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.condition = (IASTExpression)other;
        }
    }
}

