/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;

public class CASTUnaryExpression
extends ASTNode
implements IASTUnaryExpression,
IASTAmbiguityParent {
    private int operator;
    private IASTExpression operand;

    public CASTUnaryExpression() {
    }

    public CASTUnaryExpression(int operator, IASTExpression operand) {
        this.operator = operator;
        this.setOperand(operand);
    }

    public CASTUnaryExpression copy() {
        CASTUnaryExpression copy = new CASTUnaryExpression(this.operator, this.operand == null ? null : this.operand.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int value) {
        this.assertNotFrozen();
        this.operator = value;
    }

    public IASTExpression getOperand() {
        return this.operand;
    }

    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand != null && !this.operand.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType type = this.getOperand().getExpressionType();
        int op = this.getOperator();
        try {
            if (op == 4 && (type instanceof IPointerType || type instanceof IArrayType)) {
                return ((ITypeContainer)type).getType();
            }
            if (op == 5) {
                return new CPointerType(type, 0);
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return type;
    }
}

