/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTExpressionList
extends ASTNode
implements IASTExpressionList,
IASTAmbiguityParent {
    private IASTExpression[] expressions = new IASTExpression[2];

    public CASTExpressionList copy() {
        CASTExpressionList copy = new CASTExpressionList();
        IASTExpression[] iASTExpressionArray = this.getExpressions();
        int n = iASTExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression expr = iASTExpressionArray[n2];
            copy.addExpression(expr == null ? null : expr.copy());
            ++n2;
        }
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression[] getExpressions() {
        if (this.expressions == null) {
            return IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        return (IASTExpression[])ArrayUtil.trim(IASTExpression.class, this.expressions);
    }

    public void addExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.expressions = (IASTExpression[])ArrayUtil.append(IASTExpression.class, this.expressions, expression);
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NESTED_EXPRESSION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTExpression[] exps = this.getExpressions();
        int i = 0;
        while (i < exps.length) {
            if (!exps[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.expressions == null) {
            return;
        }
        int i = 0;
        while (i < this.expressions.length) {
            if (child == this.expressions[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.expressions[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    public IType getExpressionType() {
        int i = this.expressions.length - 1;
        while (i >= 0) {
            IASTExpression expr = this.expressions[i];
            if (expr != null) {
                return expr.getExpressionType();
            }
            --i;
        }
        return null;
    }
}

