/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public final class CASTAmbiguityResolver
extends ASTVisitor {
    public CASTAmbiguityResolver() {
        super(false);
        this.includeInactiveNodes = true;
        this.shouldVisitAmbiguousNodes = true;
    }

    public int visit(ASTAmbiguousNode astAmbiguousNode) {
        IASTNode node = astAmbiguousNode.resolveAmbiguity(this);
        if (node instanceof IASTDeclarator || node instanceof IASTParameterDeclaration || node instanceof IASTDeclaration) {
            while (node != null) {
                if (node instanceof IASTDeclaration || node instanceof IASTParameterDeclaration) {
                    this.repopulateScope(node);
                } else if (!(node instanceof IASTExpression)) {
                    node = node.getParent();
                    continue;
                }
                break;
            }
        } else if (node instanceof IASTDeclarationStatement) {
            this.repopulateScope(((IASTDeclarationStatement)node).getDeclaration());
        }
        return 1;
    }

    private void repopulateScope(IASTNode node) {
        IScope scope = CVisitor.getContainingScope(node);
        if (scope instanceof CScope) {
            CScope cscope = (CScope)scope;
            if (scope instanceof ICCompositeTypeScope) {
                cscope.markAsUncached();
            } else {
                cscope.collectNames(node);
            }
        }
    }
}

