/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.core.runtime.Assert;

public abstract class ASTAmbiguousBinaryVsCastExpression
extends ASTAmbiguousNode
implements IASTAmbiguousExpression {
    private final IASTBinaryExpression fBinaryExpression;
    private final IASTCastExpression fCastExpression;

    public ASTAmbiguousBinaryVsCastExpression(IASTBinaryExpression binaryExpression, IASTCastExpression castExpression) {
        this.fBinaryExpression = binaryExpression;
        this.fCastExpression = castExpression;
    }

    public final IASTExpression copy() {
        throw new UnsupportedOperationException();
    }

    public void addExpression(IASTExpression e) {
        Assert.isLegal((boolean)false);
    }

    public IType getExpressionType() {
        return null;
    }

    public final IASTNode[] getNodes() {
        return this.getExpressions();
    }

    public IASTExpression[] getExpressions() {
        return new IASTExpression[]{this.fBinaryExpression, this.fCastExpression};
    }

    public final IASTNode resolveAmbiguity(ASTVisitor visitor) {
        IASTAmbiguityParent owner = (IASTAmbiguityParent)((Object)this.getParent());
        IASTExpression nodeToReplace = this;
        owner.replace(nodeToReplace, this.fCastExpression);
        nodeToReplace = this.fCastExpression;
        this.fCastExpression.getTypeId().accept(visitor);
        owner.replace(nodeToReplace, this.fBinaryExpression);
        nodeToReplace = this.fBinaryExpression;
        this.fBinaryExpression.accept(visitor);
        ASTAmbiguousNode.NameCollector nameCollector = new ASTAmbiguousNode.NameCollector();
        this.fCastExpression.getTypeId().accept(nameCollector);
        IASTName[] names = nameCollector.getNames();
        boolean hasIssue = false;
        IASTName[] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IASTName name = iASTNameArray[n2];
                try {
                    IBinding b = name.resolveBinding();
                    if (b instanceof IProblemBinding) {
                        hasIssue = true;
                    }
                    break block7;
                }
                catch (Exception exception) {
                    hasIssue = true;
                }
                break;
            }
            ++n2;
        }
        if (hasIssue) {
            return nodeToReplace;
        }
        IASTExpression left = this.fBinaryExpression.getOperand1();
        IASTExpression right = this.fBinaryExpression.getOperand2();
        left.setParent(null);
        right.setParent(null);
        IASTUnaryExpression primaryInParenthesis = this.findTrailingBracketedPrimaryExpression(left);
        IASTExpression leadingCastExpression = this.findLeadingCastExpression(right);
        IASTExpression castedUnary = this.fCastExpression.getOperand();
        if (primaryInParenthesis != null && leadingCastExpression != null && castedUnary instanceof IASTUnaryExpression) {
            IASTExpression lp = (IASTExpression)primaryInParenthesis.getParent();
            IASTBinaryExpression rp = (IASTBinaryExpression)leadingCastExpression.getParent();
            ((IASTUnaryExpression)castedUnary).setOperand(leadingCastExpression);
            this.setEnd(castedUnary, leadingCastExpression);
            this.setRange(this.fCastExpression, primaryInParenthesis, leadingCastExpression);
            IASTExpression root = this.joinExpressions(lp, this.fCastExpression, rp);
            if (root != null) {
                owner.replace(nodeToReplace, root);
                return root;
            }
        }
        return nodeToReplace;
    }

    private void setEnd(IASTNode node, IASTNode end) {
        ASTNode target = (ASTNode)node;
        ASTNode e = (ASTNode)end;
        target.setLength(e.getOffset() + e.getLength() - target.getOffset());
    }

    private void setStart(IASTNode node, IASTNode start) {
        ASTNode target = (ASTNode)node;
        int offset = ((ASTNode)start).getOffset();
        target.setOffsetAndLength(offset, target.getOffset() + target.getLength() - offset);
    }

    private void setRange(IASTNode node, IASTNode from, IASTNode to) {
        int offset = ((ASTNode)from).getOffset();
        ASTNode t = (ASTNode)to;
        ((ASTNode)node).setOffsetAndLength(offset, t.getOffset() + t.getLength() - offset);
    }

    private IASTExpression joinExpressions(IASTExpression l, IASTExpression middle, IASTBinaryExpression r) {
        while (true) {
            if (l == null) {
                if (r == null) {
                    return middle;
                }
                r.setOperand1(middle);
                this.setStart(r, middle);
                middle = r;
                r = (IASTBinaryExpression)r.getParent();
                continue;
            }
            if (l instanceof IASTCastExpression) {
                ((IASTCastExpression)l).setOperand(middle);
                this.setEnd(l, middle);
                middle = l;
                l = (IASTExpression)l.getParent();
                continue;
            }
            if (l instanceof IASTUnaryExpression) {
                ((IASTUnaryExpression)l).setOperand(middle);
                this.setEnd(l, middle);
                middle = l;
                l = (IASTExpression)l.getParent();
                continue;
            }
            if (r == null || this.getPrecendence((IASTBinaryExpression)l) >= this.getPrecendence(r)) {
                ((IASTBinaryExpression)l).setOperand2(middle);
                this.setEnd(l, middle);
                middle = l;
                l = (IASTExpression)l.getParent();
                continue;
            }
            r.setOperand1(middle);
            this.setStart(r, middle);
            middle = r;
            r = (IASTBinaryExpression)r.getParent();
        }
    }

    private int getPrecendence(IASTBinaryExpression r) {
        switch (r.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 34: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 15: {
                return 2;
            }
            case 14: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 28: 
            case 29: {
                return 6;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 32: 
            case 33: {
                return 7;
            }
            case 6: 
            case 7: {
                return 8;
            }
            case 4: 
            case 5: {
                return 9;
            }
            case 1: 
            case 2: 
            case 3: {
                return 10;
            }
            case 30: 
            case 31: {
                return 11;
            }
        }
        assert (false);
        return 0;
    }

    private IASTUnaryExpression findTrailingBracketedPrimaryExpression(IASTExpression expr) {
        while (true) {
            if (expr instanceof IASTBinaryExpression) {
                expr = ((IASTBinaryExpression)expr).getOperand2();
                continue;
            }
            if (expr instanceof IASTCastExpression) {
                expr = ((IASTCastExpression)expr).getOperand();
                continue;
            }
            if (!(expr instanceof IASTUnaryExpression)) break;
            IASTUnaryExpression u = (IASTUnaryExpression)expr;
            if (u.getOperator() == 11) {
                return u;
            }
            expr = u.getOperand();
        }
        return null;
    }

    private IASTExpression findLeadingCastExpression(IASTExpression expr) {
        while (expr instanceof IASTBinaryExpression) {
            expr = ((IASTBinaryExpression)expr).getOperand1();
        }
        return expr;
    }
}

