/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;

public abstract class AbstractScannerExtensionConfiguration
implements IScannerExtensionConfiguration {
    private static final IMacro[] EMPTY_MACRO_ARRAY = new IMacro[0];
    private ArrayList<IMacro> fAddMacroList;
    private IMacro[] fAddMacros;
    private CharArrayIntMap fAddKeywords;
    private CharArrayIntMap fAddPreprocessorKeywords;

    public boolean support$InIdentifiers() {
        return false;
    }

    public boolean supportAtSignInIdentifiers() {
        return false;
    }

    public boolean supportUTFLiterals() {
        return true;
    }

    public boolean supportSlashPercentComments() {
        return false;
    }

    public char[] supportAdditionalNumericLiteralSuffixes() {
        return null;
    }

    public boolean supportMinAndMaxOperators() {
        return false;
    }

    public CharArrayIntMap getAdditionalPreprocessorKeywords() {
        return this.fAddPreprocessorKeywords;
    }

    public CharArrayIntMap getAdditionalKeywords() {
        return this.fAddKeywords;
    }

    public IMacro[] getAdditionalMacros() {
        if (this.fAddMacros == null) {
            this.fAddMacros = this.fAddMacroList == null ? EMPTY_MACRO_ARRAY : this.fAddMacroList.toArray(new IMacro[this.fAddMacroList.size()]);
        }
        return this.fAddMacros;
    }

    protected void addMacro(String signature, String value) {
        if (this.fAddMacroList == null) {
            this.fAddMacroList = new ArrayList();
        }
        this.fAddMacroList.add(new MacroDefinition(signature.toCharArray(), value.toCharArray()));
        this.fAddMacros = null;
    }

    protected void addPreprocessorKeyword(char[] name, int tokenKind) {
        if (this.fAddPreprocessorKeywords == null) {
            this.fAddPreprocessorKeywords = new CharArrayIntMap(10, -1);
        }
        this.fAddPreprocessorKeywords.put(name, tokenKind);
    }

    protected void addKeyword(char[] name, int tokenKind) {
        if (this.fAddKeywords == null) {
            this.fAddKeywords = new CharArrayIntMap(10, -1);
        }
        this.fAddKeywords.put(name, tokenKind);
    }

    @Deprecated
    protected static IMacro createMacro(String signature, String value) {
        return new MacroDefinition(signature.toCharArray(), value.toCharArray());
    }

    @Deprecated
    protected static IMacro createFunctionStyleMacro(String name, String value, String[] arguments) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('(');
        int i = 0;
        while (i < arguments.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(arguments[i]);
            ++i;
        }
        buf.append(')');
        char[] signature = new char[buf.length()];
        buf.getChars(0, signature.length, signature, 0);
        return new MacroDefinition(signature, value.toCharArray());
    }

    @Deprecated
    public boolean initializeMacroValuesTo1() {
        return false;
    }

    protected static class MacroDefinition
    implements IMacro {
        private char[] fSignature;
        private char[] fExpansion;

        MacroDefinition(char[] signature, char[] expansion) {
            this.fSignature = signature;
            this.fExpansion = expansion;
        }

        public char[] getSignature() {
            return this.fSignature;
        }

        public char[] getExpansion() {
            return this.fExpansion;
        }
    }
}

