/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Properties;
import org.eclipse.cdt.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryExporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SRecordExporter
implements IMemoryExporter {
    File fOutputFile;
    BigInteger fStartAddress;
    BigInteger fEndAddress;
    private Text fStartText;
    private Text fEndText;
    private Text fLengthText;
    private Text fFileText;
    private IMemoryBlock fMemoryBlock;
    private ExportMemoryDialog fParentDialog;
    private Properties fProperties;

    public Control createControl(final Composite parent, IMemoryBlock memBlock, Properties properties, ExportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                SRecordExporter.this.fProperties.setProperty("File", SRecordExporter.this.fFileText.getText());
                SRecordExporter.this.fProperties.setProperty("Start", SRecordExporter.this.fStartText.getText());
                SRecordExporter.this.fProperties.setProperty("End", SRecordExporter.this.fEndText.getText());
                SRecordExporter.this.fStartAddress = SRecordExporter.this.getStartAddress();
                SRecordExporter.this.fEndAddress = SRecordExporter.this.getEndAddress();
                SRecordExporter.this.fOutputFile = SRecordExporter.this.getFile();
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label startLabel = new Label(composite, 0);
        startLabel.setText("Start address: ");
        FormData data = new FormData();
        startLabel.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 0);
        data = new FormData();
        data.left = new FormAttachment((Control)startLabel);
        data.width = 100;
        this.fStartText.setLayoutData((Object)data);
        Label endLabel = new Label(composite, 0);
        endLabel.setText("End address: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fStartText);
        endLabel.setLayoutData((Object)data);
        this.fEndText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)endLabel);
        data.width = 100;
        this.fEndText.setLayoutData((Object)data);
        Label lengthLabel = new Label(composite, 0);
        lengthLabel.setText("Length: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fEndText);
        lengthLabel.setLayoutData((Object)data);
        this.fLengthText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)lengthLabel);
        data.width = 100;
        this.fLengthText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 0);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText("File name: ");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fLengthText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        this.fFileText.setText(properties.getProperty("File", ""));
        try {
            BigInteger startAddress = null;
            startAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
            if (properties.getProperty("Start") != null) {
                this.fStartText.setText(properties.getProperty("Start"));
            } else {
                this.fStartText.setText("0x" + startAddress.toString(16));
            }
            if (properties.getProperty("End") != null) {
                this.fEndText.setText(properties.getProperty("End"));
            } else {
                this.fEndText.setText("0x" + startAddress.toString(16));
            }
            this.fLengthText.setText(this.getEndAddress().subtract(this.getStartAddress()).toString());
        }
        catch (Exception e) {
            MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText("Choose memory export file");
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{"All Files"});
                dialog.setFileName(SRecordExporter.this.fFileText.getText());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    SRecordExporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                SRecordExporter.this.validate();
            }
        });
        this.fStartText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                boolean valid = true;
                try {
                    SRecordExporter.this.getStartAddress();
                }
                catch (Exception exception) {
                    valid = false;
                }
                SRecordExporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                BigInteger endAddress = SRecordExporter.this.getEndAddress();
                BigInteger startAddress = SRecordExporter.this.getStartAddress();
                SRecordExporter.this.fLengthText.setText(endAddress.subtract(startAddress).toString());
                SRecordExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fEndText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    SRecordExporter.this.getEndAddress();
                    SRecordExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger endAddress = SRecordExporter.this.getEndAddress();
                    BigInteger startAddress = SRecordExporter.this.getStartAddress();
                    String lengthString = endAddress.subtract(startAddress).toString();
                    if (!SRecordExporter.this.fLengthText.getText().equals(lengthString)) {
                        SRecordExporter.this.fLengthText.setText(lengthString);
                    }
                }
                catch (Exception exception) {
                    SRecordExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                }
                SRecordExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fLengthText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    BigInteger length = SRecordExporter.this.getLength();
                    SRecordExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger startAddress = SRecordExporter.this.getStartAddress();
                    String endString = "0x" + startAddress.add(length).toString(16);
                    if (!SRecordExporter.this.fEndText.getText().equals(endString)) {
                        SRecordExporter.this.fEndText.setText(endString);
                    }
                }
                catch (Exception exception) {
                    SRecordExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                SRecordExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFileText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                SRecordExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SRecordExporter.this.validate();
            }
        });
        return composite;
    }

    public BigInteger getEndAddress() {
        String text = this.fEndText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public BigInteger getLength() {
        String text = this.fLengthText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger lengthAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return lengthAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText());
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getEndAddress();
            this.getStartAddress();
            BigInteger length = this.getLength();
            if (length.compareTo(BigInteger.ZERO) <= 0) {
                isValid = false;
            }
            if (!this.getFile().getParentFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception exception) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public String getId() {
        return "srecord";
    }

    public String getName() {
        return "SRecord";
    }

    public void exportMemory() {
        Job job = new Job("Memory Export to S-Record File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BigInteger DATA_PER_RECORD = BigInteger.valueOf(16L);
                    BigInteger transferAddress = SRecordExporter.this.fStartAddress;
                    FileWriter writer = new FileWriter(SRecordExporter.this.fOutputFile);
                    BigInteger jobs = SRecordExporter.this.fEndAddress.subtract(transferAddress).divide(DATA_PER_RECORD);
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask("Transferring Data", jobs.intValue());
                    BigInteger jobCount = BigInteger.ZERO;
                    while (transferAddress.compareTo(SRecordExporter.this.fEndAddress) < 0 && !monitor.isCanceled()) {
                        String bString;
                        BigInteger length = DATA_PER_RECORD;
                        if (SRecordExporter.this.fEndAddress.subtract(transferAddress).compareTo(length) < 0) {
                            length = SRecordExporter.this.fEndAddress.subtract(transferAddress);
                        }
                        monitor.subTask(String.format("Transfering %s bytes at address 0x%s", length.toString(10), transferAddress.toString(16)));
                        writer.write("S3");
                        StringBuffer buf = new StringBuffer();
                        BigInteger sRecordLength = BigInteger.valueOf(4L);
                        sRecordLength = sRecordLength.add(length);
                        sRecordLength = sRecordLength.add(BigInteger.ONE);
                        String transferAddressString = transferAddress.toString(16);
                        String lengthString = sRecordLength.toString(16);
                        if (lengthString.length() == 1) {
                            buf.append("0");
                        }
                        buf.append(lengthString);
                        int i = 0;
                        while (i < 8 - transferAddressString.length()) {
                            buf.append("0");
                            ++i;
                        }
                        buf.append(transferAddressString);
                        MemoryByte[] bytes = ((IMemoryBlockExtension)SRecordExporter.this.fMemoryBlock).getBytesFromAddress(transferAddress, length.longValue() / (long)((IMemoryBlockExtension)SRecordExporter.this.fMemoryBlock).getAddressableSize());
                        int byteIndex = 0;
                        while (byteIndex < bytes.length) {
                            bString = BigInteger.valueOf(0xFF & bytes[byteIndex].getValue()).toString(16);
                            if (bString.length() == 1) {
                                buf.append("0");
                            }
                            buf.append(bString);
                            ++byteIndex;
                        }
                        int checksum = 0;
                        int i2 = 0;
                        while (i2 < buf.length()) {
                            BigInteger value = new BigInteger(buf.substring(i2, i2 + 2), 16);
                            checksum = (byte)(checksum + value.byteValue());
                            i2 += 2;
                        }
                        bString = BigInteger.valueOf(255 - checksum).and(BigInteger.valueOf(255L)).toString(16);
                        if (bString.length() == 1) {
                            buf.append("0");
                        }
                        buf.append(bString);
                        writer.write(buf.toString().toUpperCase());
                        writer.write("\n");
                        transferAddress = transferAddress.add(length);
                        jobCount = jobCount.add(BigInteger.ONE);
                        if (jobCount.compareTo(factor) != 0) continue;
                        jobCount = BigInteger.ZERO;
                        monitor.worked(1);
                    }
                    writer.close();
                    monitor.done();
                }
                catch (IOException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, "Could not write to file.", (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, "Could not write to file.", (Throwable)ex);
                }
                catch (DebugException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, "Could not read from target.", (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, "Could not read from target.", (Throwable)ex);
                }
                catch (Exception ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure exporting memory", (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure exporting memory", (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

