/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import java.io.File;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class RemoteRunLaunchDelegate
extends AbstractCLaunchDelegate {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block27: {
            IBinaryParser.IBinaryObject exeFile = null;
            IPath exePath = this.verifyProgramPath(config);
            ICProject project = this.verifyCProject(config);
            if (exePath != null) {
                exeFile = this.verifyBinary(project, exePath);
                String arguments = this.getProgramArguments(config);
                String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
                String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (!RSECorePlugin.isInitComplete((int)1)) {
                    monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
                    try {
                        RSECorePlugin.waitForInitCompletion((int)1);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(4, this.getPluginID(), 0, e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                if (mode.equals("debug")) {
                    monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
                    this.setDefaultSourceLocator(launch, config);
                    String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                    if (debugMode.equals("run")) {
                        Process remoteShellProcess = null;
                        ICDISession dsession = null;
                        try {
                            try {
                                monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                                this.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                                String gdbserver_port_number = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
                                String gdbserver_command = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                                String command_arguments = ":" + gdbserver_port_number + " " + this.spaceEscapify(remoteExePath);
                                if (arguments != null && !arguments.equals("")) {
                                    command_arguments = String.valueOf(command_arguments) + " " + arguments;
                                }
                                monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
                                remoteShellProcess = this.remoteShellExec(config, prelaunchCmd, gdbserver_command, command_arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                                DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
                                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, this.getRemoteHostname(config));
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, gdbserver_port_number);
                                wc.doSave();
                                GDBServerCDIDebugger2 debugger = new GDBServerCDIDebugger2();
                                dsession = debugger.createSession(launch, exePath.toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                                boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                                String stopSymbol = null;
                                if (stopInMain) {
                                    stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                                }
                                ICDITarget[] targets = dsession.getTargets();
                                int i = 0;
                                while (i < targets.length) {
                                    Process process = targets[i].getProcess();
                                    IProcess iprocess = null;
                                    if (process != null) {
                                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                                    }
                                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderProcessLabel("gdbserver debugger"), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                                    ++i;
                                }
                            }
                            catch (CoreException e) {
                                try {
                                    if (dsession != null) {
                                        dsession.terminate();
                                    }
                                    if (remoteShellProcess != null) {
                                        remoteShellProcess.destroy();
                                    }
                                }
                                catch (CDIException cDIException) {}
                                throw e;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                } else {
                    if (mode.equals("run")) {
                        monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
                        Process remoteProcess = null;
                        try {
                            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                            this.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_12);
                            remoteProcess = this.remoteShellExec(config, prelaunchCmd, remoteExePath, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            DebugPlugin.newProcess((ILaunch)launch, (Process)remoteProcess, (String)this.renderProcessLabel(exePath.toOSString()));
                            break block27;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    Status status = new Status(4, this.getPluginID(), 0, NLS.bind((String)Messages.RemoteRunLaunchDelegate_1, (Object)mode), null);
                    throw new CoreException((IStatus)status);
                }
            }
        }
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    protected IHost getCurrentConnection(ILaunchConfiguration config) throws CoreException {
        String remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        IHost connection = RSEHelper.getRemoteConnectionByName(remoteConnection);
        if (connection == null) {
            this.abort(Messages.RemoteRunLaunchDelegate_13, null, 150);
        }
        return connection;
    }

    protected Process remoteFileDownload(ILaunchConfiguration config, ILaunch launch, String localExePath, String remoteExePath, IProgressMonitor monitor) throws CoreException {
        boolean skipDownload = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        if (skipDownload) {
            return null;
        }
        monitor.beginTask(Messages.RemoteRunLaunchDelegate_2, 100);
        try {
            try {
                IFileService fileService = (IFileService)RSEHelper.getConnectedRemoteFileService(this.getCurrentConnection(config), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                File file = new File(localExePath);
                Path remotePath = new Path(remoteExePath);
                fileService.upload(file, remotePath.removeLastSegments(1).toString(), remotePath.lastSegment(), true, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
                Process p = this.remoteShellExec(config, "", "chmod", "+x " + this.spaceEscapify(remotePath.toString()), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                Thread.sleep(500L);
                p.destroy();
            }
            catch (SystemOperationCancelledException e) {
                this.cancel(e.getLocalizedMessage(), 8);
                monitor.done();
            }
            catch (Exception e) {
                this.abort(Messages.RemoteRunLaunchDelegate_6, e, 150);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected String getRemoteHostname(ILaunchConfiguration config) throws CoreException {
        IHost currentConnection = this.getCurrentConnection(config);
        return currentConnection.getHostName();
    }

    protected Process remoteShellExec(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String real_remote_command = arguments == null ? this.spaceEscapify(remoteCommandPath) : String.valueOf(this.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remote_command = String.valueOf(real_remote_command) + CMD_DELIMITER + EXIT_CMD;
        if (!prelaunchCmd.trim().equals("")) {
            remote_command = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remote_command;
        }
        Process p = null;
        try {
            IShellService shellService = (IShellService)RSEHelper.getConnectedRemoteShellService(this.getCurrentConnection(config), (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            String[] env = new String[]{};
            try {
                IHostShell hostShell = shellService.launchShell("", env, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                hostShell.writeToShell(remote_command);
                p = new HostShellProcessAdapter(hostShell);
            }
            catch (Exception e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
            }
        }
        catch (Exception e1) {
            this.abort(e1.getMessage(), e1, 150);
        }
        monitor.done();
        return p;
    }

    protected String getPluginID() {
        return "org.eclipse.rse.internal.remotecdt";
    }
}

