/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeTargetTransferData {
    private final List<MakeTargetData> makeTargetData = new ArrayList<MakeTargetData>();

    public void addMakeTarget(IMakeTarget target) {
        this.addMakeTarget(target.getName(), target.runAllBuilders(), target.appendProjectEnvironment(), target.getBuildAttribute(IMakeTarget.BUILD_TARGET, ""), target.getBuildAttribute(IMakeTarget.BUILD_COMMAND, ""), target.getBuildAttribute(IMakeTarget.BUILD_ARGUMENTS, ""), target.isStopOnError(), target.isDefaultBuildCmd(), target.appendEnvironment());
    }

    public void addMakeTarget(String name, boolean runAllBuilders, boolean appendProjectEnvironment, String buildTarget, String buildCommand, String buildArguments, boolean stopOnError, boolean useDefaultBuildCmd, boolean appendEnvironment) {
        this.makeTargetData.add(new MakeTargetData(name, runAllBuilders, appendProjectEnvironment, buildTarget, buildCommand, buildArguments, stopOnError, useDefaultBuildCmd, appendEnvironment));
    }

    public IMakeTarget[] createMakeTargets(IProject project) {
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        ArrayList<IMakeTarget> makeTargets = new ArrayList<IMakeTarget>(this.makeTargetData.size());
        String[] ids = makeTargetManager.getTargetBuilders(project);
        String builderId = ids[0];
        for (MakeTargetData element : this.makeTargetData) {
            try {
                IMakeTarget target = makeTargetManager.createTarget(project, element.getName(), builderId);
                target.setRunAllBuilders(element.runAllBuilders());
                target.setAppendProjectEnvironment(element.appendProjectEnvironment());
                target.setBuildAttribute(IMakeTarget.BUILD_TARGET, element.getBuildTarget());
                target.setBuildAttribute(IMakeTarget.BUILD_COMMAND, element.getBuildCommand());
                target.setBuildAttribute(IMakeTarget.BUILD_ARGUMENTS, element.getBuildArguments());
                target.setStopOnError(element.isStopOnError());
                target.setUseDefaultBuildCmd(element.isDefaultBuildCmd());
                target.setAppendEnvironment(element.appendEnvironment());
                makeTargets.add(target);
            }
            catch (CoreException e) {
                MakeUIPlugin.log(e);
            }
        }
        return makeTargets.toArray(new IMakeTarget[makeTargets.size()]);
    }

    List<MakeTargetData> getMakeTargetDataList() {
        return this.makeTargetData;
    }

    class MakeTargetData {
        private final String name;
        private final boolean runAllBuilders;
        private final boolean appendProjectEnvironment;
        private final String buildTarget;
        private final String buildCommand;
        private final String buildArguments;
        private final boolean stopOnError;
        private final boolean useDefaultBuildCmd;
        private final boolean appendEnvironment;

        MakeTargetData(String name, boolean runAllBuilders, boolean appendProjectEnvironment, String buildTarget, String buildCommand, String buildArguments, boolean stopOnError, boolean useDefaultBuildCmd, boolean appendEnvironment) {
            this.name = name;
            this.runAllBuilders = runAllBuilders;
            this.appendProjectEnvironment = appendProjectEnvironment;
            this.buildTarget = buildTarget;
            this.buildCommand = buildCommand;
            this.buildArguments = buildArguments;
            this.stopOnError = stopOnError;
            this.useDefaultBuildCmd = useDefaultBuildCmd;
            this.appendEnvironment = appendEnvironment;
        }

        boolean runAllBuilders() {
            return this.runAllBuilders;
        }

        boolean appendProjectEnvironment() {
            return this.appendProjectEnvironment;
        }

        String getBuildTarget() {
            return this.buildTarget;
        }

        String getBuildCommand() {
            return this.buildCommand;
        }

        String getBuildArguments() {
            return this.buildArguments;
        }

        boolean isStopOnError() {
            return this.stopOnError;
        }

        boolean isDefaultBuildCmd() {
            return this.useDefaultBuildCmd;
        }

        boolean appendEnvironment() {
            return this.appendEnvironment;
        }

        String getName() {
            return this.name;
        }
    }
}

