/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.upc.ast;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTTypedefNameSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTypedefNameSpecifier;

public class UPCASTTypedefNameSpecifier
extends CASTTypedefNameSpecifier
implements IUPCASTTypedefNameSpecifier {
    private int referenceType;
    private int sharedQualifier;
    private IASTExpression blockSizeExpression;

    public UPCASTTypedefNameSpecifier() {
    }

    public UPCASTTypedefNameSpecifier(IASTName name) {
        super(name);
    }

    public UPCASTTypedefNameSpecifier(IASTName name, IASTExpression blockSizeExpression) {
        super(name);
        this.setBlockSizeExpression(blockSizeExpression);
    }

    public UPCASTTypedefNameSpecifier copy() {
        IASTName name = this.getName();
        UPCASTTypedefNameSpecifier copy = new UPCASTTypedefNameSpecifier(name == null ? null : name.copy());
        this.copyBaseDeclSpec((CASTBaseDeclSpecifier)copy);
        copy.referenceType = this.referenceType;
        copy.sharedQualifier = this.sharedQualifier;
        copy.setBlockSizeExpression(this.blockSizeExpression == null ? null : this.blockSizeExpression.copy());
        return copy;
    }

    public IASTExpression getBlockSizeExpression() {
        return this.blockSizeExpression;
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public int getSharedQualifier() {
        return this.sharedQualifier;
    }

    public void setBlockSizeExpression(IASTExpression expr) {
        this.blockSizeExpression = expr;
        if (expr != null) {
            expr.setParent((IASTNode)this);
            expr.setPropertyInParent(BLOCK_SIZE_EXPRESSION);
        }
    }

    public void setReferenceType(int referenceType) {
        this.referenceType = referenceType;
    }

    public void setSharedQualifier(int shared) {
        this.sharedQualifier = shared;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.getName() != null && !this.getName().accept(action)) {
            return false;
        }
        if (this.blockSizeExpression != null && !this.blockSizeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

