/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class XlCSpecsConsoleParser
implements IScannerInfoConsoleParser {
    final Pattern linePattern = Pattern.compile("exec:\\s(?!export)(?:.*)\\((.*)\\)");
    final Pattern symbolPattern = Pattern.compile("-D(.*)");
    final Pattern includePattern = Pattern.compile("-(?:qgcc_c_stdinc|qc_stdinc|qgcc_cpp_stdinc|qcpp_stdinc)=(.*)");
    private IProject fProject = null;
    private IScannerInfoCollector fCollector = null;
    private List symbols = new ArrayList();
    private List includes = new ArrayList();

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        TraceUtil.outputTrace((String)"XLCSpecsConsoleParser parsing line: [", (String)line, (String)"]");
        Matcher lineMatcher = this.linePattern.matcher(line);
        if (lineMatcher.matches()) {
            String[] args = lineMatcher.group(1).split(",");
            int i = 0;
            while (i < args.length) {
                Matcher symbolMatcher = this.symbolPattern.matcher(args[i]);
                if (symbolMatcher.matches() && !this.symbols.contains(symbolMatcher.group(1))) {
                    this.symbols.add(symbolMatcher.group(1));
                } else {
                    Matcher includeMatcher = this.includePattern.matcher(args[i]);
                    if (includeMatcher.matches()) {
                        String[] includePaths = includeMatcher.group(1).split(":");
                        int j = 0;
                        while (j < includePaths.length) {
                            if (!this.includes.contains(includePaths[j])) {
                                this.includes.add(includePaths[j]);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return rc;
    }

    public void shutdown() {
        HashMap<ScannerInfoTypes, List> scannerInfo = new HashMap<ScannerInfoTypes, List>();
        scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, this.includes);
        scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, this.symbols);
        this.fCollector.contributeToScannerConfig((Object)this.fProject, scannerInfo);
        TraceUtil.outputTrace((String)"Scanner info from 'specs' file", (String)"Include paths", (List)this.includes, new ArrayList(), (String)"Defined symbols", (List)this.symbols);
    }
}

