/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.generic;

import org.eclipse.cdt.ui.text.ICTokenScanner;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.cdt.ui.text.doctools.IDocCommentDictionary;
import org.eclipse.cdt.ui.text.doctools.IDocCommentSimpleDictionary;
import org.eclipse.cdt.ui.text.doctools.IDocCommentViewerConfiguration;
import org.eclipse.cdt.ui.text.doctools.generic.GenericDocTag;
import org.eclipse.cdt.ui.text.doctools.generic.GenericTagCommentScanner;
import org.eclipse.cdt.ui.text.doctools.generic.GenericTagCompletionProposalComputer;
import org.eclipse.cdt.ui.text.doctools.generic.GenericTagDoubleClickStrategy;
import org.eclipse.cdt.ui.text.doctools.generic.GenericTagSimpleDictionary;
import org.eclipse.jface.text.ITextDoubleClickStrategy;

public abstract class AbstractGenericTagDocCommentViewerConfiguration
implements IDocCommentViewerConfiguration {
    protected GenericDocTag[] fTags;
    protected char[] fTagMarkers;
    protected ITextDoubleClickStrategy fDCStrategy;
    protected ICompletionProposalComputer fCPComputer;
    protected String fDefaultToken;
    protected String fTagToken;
    protected IDocCommentSimpleDictionary fDictionary;

    public AbstractGenericTagDocCommentViewerConfiguration(GenericDocTag[] tags, char[] tagMarkers, String defaultToken, String tagToken) {
        this.fTags = tags;
        this.fTagMarkers = tagMarkers;
        this.fDCStrategy = new GenericTagDoubleClickStrategy(tagMarkers);
        this.fCPComputer = new GenericTagCompletionProposalComputer(this.fTags, tagMarkers);
        this.fDefaultToken = defaultToken;
        this.fTagToken = tagToken;
        this.fDictionary = new GenericTagSimpleDictionary(this.fTags, this.fTagMarkers);
    }

    public ICTokenScanner createCommentScanner(ITokenStoreFactory tokenStoreFactory) {
        return new GenericTagCommentScanner(this.fTags, this.fTagMarkers, tokenStoreFactory, this.fDefaultToken, this.fTagToken);
    }

    public ITextDoubleClickStrategy createDoubleClickStrategy() {
        return this.fDCStrategy;
    }

    public ICompletionProposalComputer createProposalComputer() {
        return this.fCPComputer;
    }

    public IDocCommentDictionary getSpellingDictionary() {
        return this.fDictionary;
    }
}

