/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RefsTab
extends AbstractCPropertyTab {
    public Composite comp;
    private Tree tree;
    private static final String ACTIVE = "[" + UIMessages.getString("RefsTab.3") + "]";

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.initButtons(new String[]{UIMessages.getString("RefsTab.0"), UIMessages.getString("RefsTab.2")}, 120);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.tree = new Tree(this.usercomp, 2084);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("RefsTab.4");
            }
        });
        this.initData();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ((e.detail & 0x20) == 32 && e.item != null && e.item instanceof TreeItem) {
                    TreeItem sel = (TreeItem)e.item;
                    Object x = sel.getData();
                    if (x instanceof IProject) {
                        TreeItem[] objs = sel.getItems();
                        if (sel.getChecked()) {
                            sel.setExpanded(true);
                            objs[0].setChecked(true);
                        } else {
                            TreeItem[] treeItemArray = objs;
                            int n = objs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem obj = treeItemArray[n2];
                                obj.setChecked(false);
                                ++n2;
                            }
                        }
                    } else {
                        TreeItem parent = sel.getParentItem();
                        TreeItem[] objs = parent.getItems();
                        if (sel.getChecked()) {
                            if (parent.getChecked()) {
                                TreeItem[] treeItemArray = objs;
                                int n = objs.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    TreeItem obj = treeItemArray[n3];
                                    obj.setChecked(false);
                                    ++n3;
                                }
                                sel.setChecked(true);
                            } else {
                                parent.setChecked(true);
                            }
                        } else {
                            parent.setChecked(false);
                        }
                    }
                    RefsTab.this.saveChecked();
                }
                RefsTab.this.updateButtons();
            }
        });
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                RefsTab.this.updateButtons(e, false, true);
            }

            public void treeExpanded(TreeEvent e) {
                RefsTab.this.updateButtons(e, true, false);
            }
        });
    }

    public void buttonPressed(int n) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n2 = treeItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TreeItem item = treeItemArray[n3];
            item.setExpanded(n == 0);
            ++n3;
        }
    }

    protected void updateData(ICResourceDescription cfgd) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
        } else {
            if (!this.usercomp.getVisible()) {
                this.setAllVisible(true, null);
            }
            this.initData();
        }
    }

    private void saveChecked() {
        TreeItem[] tr = this.tree.getItems();
        HashMap<String, String> refs = new HashMap<String, String>();
        TreeItem[] treeItemArray = tr;
        int n = tr.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            if (element.getChecked()) {
                TreeItem[] cfgs = element.getItems();
                int j = 0;
                while (j < cfgs.length) {
                    if (cfgs[j].getChecked()) {
                        Object ob;
                        String cfgId = "";
                        if (j > 0 && (ob = cfgs[j].getData()) instanceof ICConfigurationDescription) {
                            cfgId = ((ICConfigurationDescription)ob).getId();
                        }
                        refs.put(element.getText(), cfgId);
                        break;
                    }
                    ++j;
                }
            }
            ++n2;
        }
        this.getResDesc().getConfiguration().setReferenceInfo(refs);
    }

    private void initData() {
        this.tree.removeAll();
        IProject p = this.page.getProject();
        if (p == null) {
            return;
        }
        IProject[] ps = p.getWorkspace().getRoot().getProjects();
        Map refs = this.getResDesc().getConfiguration().getReferenceInfo();
        int i = 0;
        while (i < ps.length) {
            ICConfigurationDescription[] cfgs;
            if (!p.equals((Object)ps[i]) && (cfgs = this.page.getCfgsReadOnly(ps[i])) != null && cfgs.length != 0) {
                String name = ps[i].getName();
                String ref = null;
                TreeItem ti = new TreeItem(this.tree, 0);
                ti.setText(name);
                ti.setData((Object)ps[i]);
                if (refs.containsKey(name)) {
                    ref = (String)refs.get(name);
                    ti.setChecked(true);
                }
                TreeItem ti1 = new TreeItem(ti, 0);
                ti1.setText(ACTIVE);
                ti1.setData((Object)new ActiveCfg(ps[i]));
                if ("".equals(ref)) {
                    ti1.setChecked(true);
                }
                ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
                int n = cfgs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                    ti1 = new TreeItem(ti, 0);
                    ti1.setText(cfg.getName());
                    ti1.setData((Object)cfg);
                    if (cfg.getId().equals(ref)) {
                        ti1.setChecked(true);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        this.updateButtons();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        dst.getConfiguration().setReferenceInfo(src.getConfiguration().getReferenceInfo());
    }

    public boolean canBeVisible() {
        return this.page.isForProject() && !this.page.isMultiCfg();
    }

    protected void performDefaults() {
        this.getResDesc().getConfiguration().setReferenceInfo(new HashMap());
        this.initData();
    }

    protected void updateButtons() {
        this.updateButtons(null, false, false);
    }

    private void updateButtons(TreeEvent e, boolean stateE, boolean stateC) {
        boolean cntE = stateE;
        boolean cntC = stateC;
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (e == null || !e.widget.equals(item)) {
                if (item.getExpanded()) {
                    cntE = true;
                } else {
                    cntC = true;
                }
            }
            ++n2;
        }
        this.buttonSetEnabled(0, cntC);
        this.buttonSetEnabled(1, cntE);
    }

    class ActiveCfg {
        IProject project;

        public ActiveCfg(IProject _project) {
            this.project = _project;
        }

        public String toString() {
            return ACTIVE;
        }
    }
}

