/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;

public class CDTPropertyManager {
    private static ArrayList<Object> pages = new ArrayList();
    private static ICProjectDescription prjd = null;
    private static boolean saveDone = false;
    private static IProject project = null;
    private static DListener dListener = new DListener();

    public static ICProjectDescription getProjectDescription(PropertyPage p, IProject prj) {
        return CDTPropertyManager.get(p, prj);
    }

    public static ICProjectDescription getProjectDescription(Widget w, IProject prj) {
        return CDTPropertyManager.get(w, prj);
    }

    public static ICProjectDescription getProjectDescription(IProject prj) {
        return CDTPropertyManager.get(null, prj);
    }

    private static ICProjectDescription get(Object p, IProject prj) {
        if (pages.size() == 0) {
            project = null;
            prjd = null;
            saveDone = false;
        }
        if (p != null && !pages.contains(p)) {
            pages.add(p);
            if (p instanceof PropertyPage) {
                if (((PropertyPage)p).getControl() != null) {
                    ((PropertyPage)p).getControl().addDisposeListener((DisposeListener)dListener);
                }
            } else if (p instanceof Widget) {
                ((Widget)p).addDisposeListener((DisposeListener)dListener);
            }
        }
        if (project == null || !project.equals((Object)prj)) {
            project = prj;
            prjd = null;
        }
        if (prjd == null) {
            prjd = CoreModel.getDefault().getProjectDescription(prj);
        }
        return prjd;
    }

    public static void performOk(Object p) {
        if (saveDone) {
            return;
        }
        CDTPropertyManager.performOkForced(p);
        if (pages.size() == 0) {
            project = null;
            prjd = null;
            saveDone = false;
        }
    }

    public static void performCancel(Object p) {
        saveDone = true;
        if (pages.size() == 0) {
            project = null;
            prjd = null;
            saveDone = false;
        }
    }

    public static void remove(Object p) {
        DListener.dispose(p);
    }

    public static void performOkForced(Object p) {
        saveDone = true;
        try {
            CoreModel.getDefault().setProjectDescription(project, prjd);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().logErrorMessage(String.valueOf(UIMessages.getString("AbstractPage.11")) + e.getLocalizedMessage());
        }
        if (pages.size() == 0) {
            project = null;
            prjd = null;
            saveDone = false;
        }
    }

    public static boolean isSaveDone() {
        return saveDone;
    }

    public static int getPagesCount() {
        return pages.size();
    }

    public static Object getPage(int index) {
        return pages.get(index);
    }

    static class DListener
    implements DisposeListener {
        DListener() {
        }

        public static void dispose(Object w) {
            if (pages.contains(w)) {
                pages.remove(w);
            } else {
                for (Object ob : pages) {
                    if (ob == null || !(ob instanceof PropertyPage) || !((PropertyPage)ob).getControl().equals(w)) continue;
                    pages.remove(ob);
                    break;
                }
            }
            if (pages.isEmpty()) {
                saveDone = true;
                project = null;
                prjd = null;
                saveDone = false;
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            DListener.dispose(e.widget);
        }
    }
}

