/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.Properties;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIndexerPage
extends AbstractCOptionPage {
    protected static final String INDEX_ALL_FILES = DialogsMessages.AbstractIndexerPage_indexAllFiles;
    protected static final String TRUE = String.valueOf(true);
    private Button fAllSources;
    private Button fAllHeadersDefault;
    private Button fAllHeadersAlt;
    private Button fIncludeHeuristics;
    private Text fFilesToParseUpFront;
    private Button fSkipReferences;
    private Button fSkipTypeReferences;
    private Button fSkipImplicitReferences;
    private Button fSkipMacroReferences;

    protected AbstractIndexerPage() {
    }

    public final IProject getCurrentProject() {
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            return container.getProject();
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite(parent, 1);
        this.fAllSources = this.createAllFilesButton(page);
        IProject prj = this.getCurrentProject();
        if (prj == null || !CProject.hasCCNature((IProject)prj)) {
            this.fAllHeadersDefault = this.createAllHeadersButton(page);
        } else {
            this.fAllHeadersDefault = this.createAllCppHeadersButton(page);
            this.fAllHeadersAlt = this.createAllCHeadersButton(page);
        }
        this.fIncludeHeuristics = this.createIncludeHeuristicsButton(page);
        this.fSkipReferences = this.createSkipReferencesButton(page);
        this.fSkipImplicitReferences = this.createSkipImplicitReferencesButton(page);
        this.fSkipTypeReferences = this.createSkipTypeReferencesButton(page);
        this.fSkipMacroReferences = this.createSkipMacroReferencesButton(page);
        this.fFilesToParseUpFront = this.createParseUpFrontTextField(page);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIndexerPage.this.updateEnablement();
            }
        };
        this.fSkipReferences.addSelectionListener((SelectionListener)selectionListener);
        this.fAllSources.addSelectionListener((SelectionListener)selectionListener);
        this.setControl((Control)page);
    }

    public void setProperties(Properties properties) {
        boolean indexAllFiles;
        if (this.fAllSources != null) {
            indexAllFiles = TRUE.equals(properties.get("indexAllFiles"));
            this.fAllSources.setSelection(indexAllFiles);
        }
        if (this.fAllHeadersDefault != null) {
            indexAllFiles = TRUE.equals(properties.get("indexUnusedHeadersWithDefaultLang"));
            this.fAllHeadersDefault.setSelection(indexAllFiles);
        }
        if (this.fAllHeadersAlt != null) {
            indexAllFiles = TRUE.equals(properties.get("indexUnusedHeadersWithAlternateLang"));
            this.fAllHeadersAlt.setSelection(indexAllFiles);
        }
        if (this.fIncludeHeuristics != null) {
            Object prop = properties.get("useHeuristicIncludeResolution");
            boolean use = prop == null || TRUE.equals(prop);
            this.fIncludeHeuristics.setSelection(use);
        }
        if (this.fSkipReferences != null) {
            boolean skipReferences = TRUE.equals(properties.get("skipReferences"));
            this.fSkipReferences.setSelection(skipReferences);
        }
        if (this.fSkipImplicitReferences != null) {
            boolean skipImplicitReferences = TRUE.equals(properties.get("skipImplicitReferences"));
            this.fSkipImplicitReferences.setSelection(skipImplicitReferences);
        }
        if (this.fSkipTypeReferences != null) {
            boolean skipTypeReferences = TRUE.equals(properties.get("skipTypeReferences"));
            this.fSkipTypeReferences.setSelection(skipTypeReferences);
        }
        if (this.fSkipMacroReferences != null) {
            boolean skipMacroReferences = TRUE.equals(properties.get("skipMacroReferences"));
            this.fSkipMacroReferences.setSelection(skipMacroReferences);
        }
        if (this.fFilesToParseUpFront != null) {
            String files = this.getNotNull(properties, "filesToParseUpFront");
            this.fFilesToParseUpFront.setText(files);
        }
        this.updateEnablement();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fAllSources != null) {
            props.put("indexAllFiles", String.valueOf(this.fAllSources.getSelection()));
        }
        if (this.fAllHeadersDefault != null) {
            props.put("indexUnusedHeadersWithDefaultLang", String.valueOf(this.fAllHeadersDefault.getSelection()));
        }
        if (this.fAllHeadersAlt != null) {
            props.put("indexUnusedHeadersWithAlternateLang", String.valueOf(this.fAllHeadersAlt.getSelection()));
        }
        if (this.fIncludeHeuristics != null) {
            props.put("useHeuristicIncludeResolution", String.valueOf(this.fIncludeHeuristics.getSelection()));
        }
        if (this.fFilesToParseUpFront != null) {
            props.put("filesToParseUpFront", this.fFilesToParseUpFront.getText());
        }
        if (this.fSkipReferences != null) {
            props.put("skipReferences", String.valueOf(this.fSkipReferences.getSelection()));
        }
        if (this.fSkipImplicitReferences != null) {
            props.put("skipImplicitReferences", String.valueOf(this.fSkipImplicitReferences.getSelection()));
        }
        if (this.fSkipTypeReferences != null) {
            props.put("skipTypeReferences", String.valueOf(this.fSkipTypeReferences.getSelection()));
        }
        if (this.fSkipMacroReferences != null) {
            props.put("skipMacroReferences", String.valueOf(this.fSkipMacroReferences.getSelection()));
        }
        return props;
    }

    public final void performApply(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public final void performDefaults() {
        throw new UnsupportedOperationException();
    }

    public void updateEnablement() {
        if (this.fSkipReferences != null) {
            boolean skipReferences = this.fSkipReferences.getSelection();
            if (this.fSkipImplicitReferences != null) {
                this.fSkipImplicitReferences.setEnabled(!skipReferences);
            }
            if (this.fSkipTypeReferences != null) {
                this.fSkipTypeReferences.setEnabled(!skipReferences);
            }
            if (this.fSkipMacroReferences != null) {
                this.fSkipMacroReferences.setEnabled(!skipReferences);
            }
        }
    }

    private String getNotNull(Properties properties, String key) {
        String files = (String)properties.get(key);
        if (files == null) {
            files = "";
        }
        return files;
    }

    private Text createParseUpFrontTextField(Composite page) {
        Label l = ControlFactory.createLabel(page, DialogsMessages.AbstractIndexerPage_indexUpFront);
        ((GridData)l.getLayoutData()).verticalIndent = 5;
        return ControlFactory.createTextField(page);
    }

    private Button createAllFilesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllFiles);
    }

    private Button createAllHeadersButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeaders);
    }

    private Button createAllCHeadersButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeadersC);
    }

    private Button createAllCppHeadersButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_indexAllHeadersCpp);
    }

    private Button createIncludeHeuristicsButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_heuristicIncludes);
    }

    private Button createSkipReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipAllReferences);
    }

    private Button createSkipImplicitReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipImplicitReferences);
    }

    private Button createSkipTypeReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipTypeReferences);
    }

    private Button createSkipMacroReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipMacroReferences);
    }
}

