/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfigurationElement;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSetConfigurationManager {
    static final String TYPE_WORKING_SET_CONFIGS = "org.eclipse.cdt.ui.workingSetConfigurations";
    static final String KEY_WORKING_SET = "workingSet";
    static final String ATTR_NAME = "name";
    static final String KEY_CONFIG = "config";
    static final String KEY_PROJECT = "project";
    static final String ATTR_CONFIG = "config";
    static final String ATTR_FACTORY = "factory";
    static IWorkingSetManager WS_MGR = CUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
    private static final WorkingSetConfigurationManager INSTANCE = new WorkingSetConfigurationManager();
    private Map<String, IWorkingSetProxy> workingSets;
    private final Object storeLock = new Object();
    private IMemento store;
    private final ISchedulingRule saveRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    private WorkingSetConfigurationManager() {
        this.store = this.loadMemento();
        new WorkingSetChangeTracker();
    }

    public static WorkingSetConfigurationManager getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IWorkingSetProxy> getWorkingSetMap() {
        Map<String, IWorkingSetProxy> result;
        Object object = this.storeLock;
        synchronized (object) {
            if (this.workingSets == null) {
                this.load();
            }
            result = this.workingSets;
        }
        return result;
    }

    public IWorkingSetProxy getWorkingSet(String name) {
        return this.getWorkingSetMap().get(name);
    }

    public Collection<IWorkingSetProxy> getWorkingSets() {
        return this.getWorkingSetMap().values();
    }

    public WorkspaceSnapshot createWorkspaceSnapshot() {
        return new WorkspaceSnapshot().initialize(this.getWorkingSetMap());
    }

    private void load() {
        this.workingSets = new HashMap<String, IWorkingSetProxy>();
        IMemento[] iMementoArray = this.store.getChildren(KEY_WORKING_SET);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento next = iMementoArray[n2];
            WorkingSetProxy ws = new WorkingSetProxy();
            ws.loadState(next);
            if (ws.isValid()) {
                this.workingSets.put(ws.getName(), ws);
            }
            ++n2;
        }
    }

    private void clear() {
        this.workingSets = null;
    }

    void save(WorkspaceSnapshot snapshot) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TYPE_WORKING_SET_CONFIGS);
        for (IWorkingSetConfigurationElement iWorkingSetConfigurationElement : snapshot.getWorkingSets()) {
            iWorkingSetConfigurationElement.saveState(memento.createChild(KEY_WORKING_SET));
        }
        this.save(memento);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(final XMLMemento memento) {
        Object object = this.storeLock;
        synchronized (object) {
            this.store = memento;
            this.clear();
        }
        new Job(WorkingSetMessages.WSConfigManager_save_job){
            {
                super($anonymous0);
                this.setRule(WorkingSetConfigurationManager.this.saveRule);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                File file = WorkingSetConfigurationManager.this.getStorage();
                FileWriter writer = null;
                try {
                    writer = new FileWriter(file);
                    memento.save((Writer)writer);
                    writer.close();
                }
                catch (IOException e) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {
                            CUIPlugin.log(WorkingSetMessages.WSConfigManager_closeFailed, e);
                        }
                    }
                    file.delete();
                    CUIPlugin.log(WorkingSetMessages.WSConfigManager_saveFailed, e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private File getStorage() {
        IPath path = CUIPlugin.getDefault().getStateLocation().append("workingSetConfigs.xml");
        return path.toFile();
    }

    private IMemento loadMemento() {
        XMLMemento result = null;
        File file = this.getStorage();
        if (file.exists()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                result = XMLMemento.createReadRoot((Reader)reader);
                reader.close();
            }
            catch (Exception e) {
                result = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        CUIPlugin.log(WorkingSetMessages.WSConfigManager_closeFailed, e);
                    }
                }
                CUIPlugin.log(WorkingSetMessages.WSConfigManager_loadFailed, e);
            }
        }
        if (result == null) {
            List<String> configSetStrings = CDTPrefUtil.readConfigSets();
            result = XMLMemento.createWriteRoot((String)TYPE_WORKING_SET_CONFIGS);
            HashMap<String, IMemento> configMap = new HashMap<String, IMemento>();
            for (String next : configSetStrings) {
                String[] bits = next.split(" ");
                if (bits.length < 2) continue;
                String configName = bits[0];
                String wsName = bits[1];
                IMemento workingSet = (IMemento)configMap.get(wsName);
                if (workingSet == null) {
                    workingSet = result.createChild(KEY_WORKING_SET);
                    configMap.put(wsName, workingSet);
                }
                workingSet.putString(ATTR_NAME, wsName);
                IMemento config = workingSet.createChild("config");
                config.putString(ATTR_NAME, configName);
                int limit = bits.length - bits.length % 2;
                int i = 2;
                while (i < limit) {
                    IMemento project = config.createChild(KEY_PROJECT);
                    project.putString(ATTR_NAME, bits[i]);
                    project.putString("config", bits[i + 1]);
                    i += 2;
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkingSetChangeTracker
    extends IdentityHashMap<IWorkingSet, String>
    implements IPropertyChangeListener {
        WorkingSetChangeTracker() {
            IWorkingSet[] iWorkingSetArray = WS_MGR.getWorkingSets();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet next = iWorkingSetArray[n2];
                this.put(next, next.getName());
                ++n2;
            }
            WS_MGR.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("workingSetNameChange".equals(property)) {
                this.handleNameChange((IWorkingSet)event.getNewValue());
            } else if ("workingSetRemove".equals(property)) {
                this.handleRemove((IWorkingSet)event.getOldValue());
            } else if ("workingSetAdd".equals(property)) {
                this.handleAdd((IWorkingSet)event.getNewValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNameChange(IWorkingSet workingSet) {
            Object object = WorkingSetConfigurationManager.this.storeLock;
            synchronized (object) {
                String oldName = (String)this.get(workingSet);
                IMemento wsMemento = null;
                if (oldName != null) {
                    IMemento[] iMementoArray = WorkingSetConfigurationManager.this.store.getChildren(WorkingSetConfigurationManager.KEY_WORKING_SET);
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento next = iMementoArray[n2];
                        if (oldName.equals(next.getString(WorkingSetConfigurationManager.ATTR_NAME))) {
                            wsMemento = next;
                            break;
                        }
                        ++n2;
                    }
                }
                if (wsMemento != null) {
                    wsMemento.putString(WorkingSetConfigurationManager.ATTR_NAME, workingSet.getName());
                    XMLMemento newStore = XMLMemento.createWriteRoot((String)WorkingSetConfigurationManager.TYPE_WORKING_SET_CONFIGS);
                    newStore.putMemento(WorkingSetConfigurationManager.this.store);
                    WorkingSetConfigurationManager.this.save(newStore);
                }
                this.put(workingSet, workingSet.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemove(IWorkingSet workingSet) {
            Object object = WorkingSetConfigurationManager.this.storeLock;
            synchronized (object) {
                String name = (String)this.get(workingSet);
                if (name != null) {
                    XMLMemento newStore = XMLMemento.createWriteRoot((String)WorkingSetConfigurationManager.TYPE_WORKING_SET_CONFIGS);
                    IMemento[] iMementoArray = WorkingSetConfigurationManager.this.store.getChildren(WorkingSetConfigurationManager.KEY_WORKING_SET);
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento next = iMementoArray[n2];
                        if (!name.equals(next.getString(WorkingSetConfigurationManager.ATTR_NAME))) {
                            newStore.createChild(WorkingSetConfigurationManager.KEY_WORKING_SET).putMemento(next);
                        }
                        ++n2;
                    }
                    WorkingSetConfigurationManager.this.save(newStore);
                }
                this.remove(workingSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAdd(IWorkingSet workingSet) {
            Object object = WorkingSetConfigurationManager.this.storeLock;
            synchronized (object) {
                this.put(workingSet, workingSet.getName());
            }
        }
    }
}

