/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewClassCodeGenerator {
    private IPath fHeaderPath = null;
    private IPath fSourcePath = null;
    private String fClassName = null;
    private IQualifiedTypeName fNamespace = null;
    private IBaseClassInfo[] fBaseClasses = null;
    private IMethodStub[] fMethodStubs = null;
    private ITranslationUnit fCreatedHeaderTU = null;
    private ITranslationUnit fCreatedSourceTU = null;
    private ICElement fCreatedClass = null;
    private String fFullyQualifiedClassName;
    private boolean fForceSourceFileCreation;

    public void setForceSourceFileCreation(boolean force) {
        this.fForceSourceFileCreation = force;
    }

    public NewClassCodeGenerator(IPath headerPath, IPath sourcePath, String className, String namespace, IBaseClassInfo[] baseClasses, IMethodStub[] methodStubs) {
        this.fHeaderPath = headerPath;
        this.fSourcePath = sourcePath;
        if (className != null && className.length() > 0) {
            this.fClassName = className;
        }
        if (namespace != null && namespace.length() > 0) {
            this.fNamespace = new QualifiedTypeName(namespace);
        }
        this.fFullyQualifiedClassName = this.fNamespace != null ? this.fNamespace.append(this.fClassName).getFullyQualifiedName() : this.fClassName;
        this.fBaseClasses = baseClasses;
        this.fMethodStubs = methodStubs;
    }

    public ICElement getCreatedClass() {
        return this.fCreatedClass;
    }

    public ITranslationUnit getCreatedHeaderTU() {
        return this.fCreatedHeaderTU;
    }

    public IFile getCreatedHeaderFile() {
        if (this.fCreatedHeaderTU != null) {
            return (IFile)this.fCreatedHeaderTU.getResource();
        }
        return null;
    }

    public ITranslationUnit getCreatedSourceTU() {
        return this.fCreatedSourceTU;
    }

    public IFile getCreatedSourceFile() {
        if (this.fCreatedSourceTU != null) {
            return (IFile)this.fCreatedSourceTU.getResource();
        }
        return null;
    }

    public ICElement createClass(IProgressMonitor monitor) throws CodeGeneratorException, CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_mainTask, 400);
        ITranslationUnit headerTU = null;
        ITranslationUnit sourceTU = null;
        ICElement createdClass = null;
        IWorkingCopy headerWorkingCopy = null;
        IWorkingCopy sourceWorkingCopy = null;
        try {
            List<IMethodStub> privateMethods;
            List<IMethodStub> protectedMethods;
            List<IMethodStub> publicMethods;
            if (this.fHeaderPath != null) {
                publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, false);
                protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, false);
                privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, false);
                IFile headerFile = NewSourceFileGenerator.createHeaderFile(this.fHeaderPath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (headerFile != null) {
                    headerTU = (ITranslationUnit)CoreModel.getDefault().create(headerFile);
                    headerWorkingCopy = headerTU.getWorkingCopy();
                    String headerContent = this.constructHeaderFileContent(headerTU, publicMethods, protectedMethods, privateMethods, headerWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    headerContent = this.formatSource(headerContent, headerTU);
                    headerWorkingCopy.getBuffer().setContents(headerContent);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    headerWorkingCopy.reconcile();
                    headerWorkingCopy.commit(true, monitor);
                    monitor.worked(50);
                    createdClass = headerWorkingCopy.getElement(this.fFullyQualifiedClassName);
                }
                this.fCreatedClass = createdClass;
                this.fCreatedHeaderTU = headerTU;
            }
            if (this.fSourcePath != null) {
                publicMethods = this.getStubs(ASTAccessVisibility.PUBLIC, true);
                protectedMethods = this.getStubs(ASTAccessVisibility.PROTECTED, true);
                privateMethods = this.getStubs(ASTAccessVisibility.PRIVATE, true);
                if (!this.fForceSourceFileCreation && publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty()) {
                    monitor.worked(100);
                } else {
                    IFile sourceFile = NewSourceFileGenerator.createSourceFile(this.fSourcePath, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (sourceFile != null) {
                        sourceTU = (ITranslationUnit)CoreModel.getDefault().create(sourceFile);
                        monitor.worked(50);
                        sourceWorkingCopy = sourceTU.getWorkingCopy();
                        String sourceContent = this.constructSourceFileContent(sourceTU, headerTU, publicMethods, protectedMethods, privateMethods, sourceWorkingCopy.getBuffer().getContents(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        sourceContent = this.formatSource(sourceContent, sourceTU);
                        sourceWorkingCopy.getBuffer().setContents(sourceContent);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        sourceWorkingCopy.reconcile();
                        sourceWorkingCopy.commit(true, monitor);
                        monitor.worked(50);
                    }
                    this.fCreatedSourceTU = sourceTU;
                }
            }
        }
        finally {
            if (headerWorkingCopy != null) {
                headerWorkingCopy.destroy();
            }
            if (sourceWorkingCopy != null) {
                sourceWorkingCopy.destroy();
            }
            monitor.done();
        }
        return this.fCreatedClass;
    }

    private String formatSource(String content, ITranslationUnit tu) throws CModelException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)tu);
        TextEdit edit = CodeFormatterUtil.format(8, content, 0, lineDelimiter, tu.getCProject().getOptions(true));
        if (edit != null) {
            Document doc = new Document(content);
            try {
                edit.apply((IDocument)doc);
                content = doc.get();
            }
            catch (MalformedTreeException exc) {
                CUIPlugin.log(exc);
            }
            catch (BadLocationException exc) {
                CUIPlugin.log(exc);
            }
        }
        return content;
    }

    public String constructHeaderFileContent(ITranslationUnit headerTU, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String oldContents, IProgressMonitor monitor) throws CoreException {
        String fileContent;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header, 100);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)headerTU);
        if (oldContents != null && oldContents.length() == 0) {
            oldContents = null;
        }
        StringBuffer text = new StringBuffer();
        int appendFirstCharPos = -1;
        if (oldContents != null) {
            int insertionPos = this.getClassDefInsertionPos(oldContents);
            if (insertionPos == -1) {
                text.append(oldContents);
            } else {
                int prependLastCharPos = insertionPos - 1;
                while (prependLastCharPos >= 0 && Character.isWhitespace(oldContents.charAt(prependLastCharPos))) {
                    --prependLastCharPos;
                }
                if (prependLastCharPos >= 0) {
                    text.append(oldContents.substring(0, prependLastCharPos + 1));
                }
                appendFirstCharPos = prependLastCharPos + 1;
            }
            text.append(lineDelimiter);
            text.append(lineDelimiter);
        }
        if (this.fBaseClasses != null && this.fBaseClasses.length > 0) {
            this.addBaseClassIncludes(headerTU, text, lineDelimiter, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            text.append(lineDelimiter);
        }
        if (this.fNamespace != null) {
            this.beginNamespace(text, lineDelimiter);
        }
        text.append("class ");
        text.append(this.fClassName);
        this.addBaseClassInheritance(text);
        text.append(lineDelimiter);
        text.append('{');
        text.append(lineDelimiter);
        if (!(publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty())) {
            this.addMethodDeclarations(headerTU, publicMethods, protectedMethods, privateMethods, text, lineDelimiter);
        }
        text.append("};");
        text.append(lineDelimiter);
        if (this.fNamespace != null) {
            this.endNamespace(text, lineDelimiter);
        }
        if (oldContents != null && appendFirstCharPos != -1) {
            text.append(lineDelimiter);
            int len = oldContents.length();
            while (appendFirstCharPos < len && Character.isWhitespace(oldContents.charAt(appendFirstCharPos))) {
                ++appendFirstCharPos;
            }
            if (appendFirstCharPos < len) {
                text.append(oldContents.substring(appendFirstCharPos));
            }
            fileContent = text.toString();
        } else {
            String classComment = this.getClassComment(headerTU, lineDelimiter);
            fileContent = CodeGeneration.getHeaderFileContent(headerTU, classComment, text.toString(), lineDelimiter);
        }
        monitor.done();
        return fileContent;
    }

    private int getClassDefInsertionPos(String contents) {
        if (contents.length() == 0) {
            return -1;
        }
        int insertPos = contents.lastIndexOf("#endif");
        if (insertPos != -1 && (contents.indexOf(125, insertPos) != -1 || contents.indexOf(59, insertPos) != -1)) {
            return -1;
        }
        return insertPos;
    }

    private String getClassComment(ITranslationUnit tu, String lineDelimiter) {
        if (this.isAddComments(tu)) {
            try {
                String fqName = this.fFullyQualifiedClassName;
                String comment = CodeGeneration.getClassComment(tu, fqName, lineDelimiter);
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return null;
    }

    private boolean isValidComment(String template) {
        return true;
    }

    public boolean isAddComments(ITranslationUnit tu) {
        return StubUtility.doAddComments(tu.getCProject());
    }

    private void beginNamespace(StringBuffer text, String lineDelimiter) {
        int i = 0;
        while (i < this.fNamespace.segmentCount()) {
            text.append("namespace ");
            text.append(this.fNamespace.segment(i));
            text.append(lineDelimiter);
            text.append('{');
            text.append(lineDelimiter);
            text.append(lineDelimiter);
            ++i;
        }
    }

    private void endNamespace(StringBuffer text, String lineDelimiter) {
        int i = 0;
        while (i < this.fNamespace.segmentCount()) {
            text.append(lineDelimiter);
            text.append("}");
            text.append(lineDelimiter);
            ++i;
        }
    }

    private void addMethodDeclarations(ITranslationUnit tu, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, StringBuffer text, String lineDelimiter) throws CoreException {
        String code;
        if (!publicMethods.isEmpty()) {
            text.append("public:");
            text.append(lineDelimiter);
            for (IMethodStub stub : publicMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            text.append("protected:");
            text.append(lineDelimiter);
            for (IMethodStub stub : protectedMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            text.append("private:");
            text.append(lineDelimiter);
            for (IMethodStub stub : privateMethods) {
                code = stub.createMethodDeclaration(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append('\t');
                text.append(code);
                text.append(lineDelimiter);
            }
        }
    }

    private List<IMethodStub> getStubs(ASTAccessVisibility access, boolean skipInline) {
        ArrayList<IMethodStub> list = new ArrayList<IMethodStub>();
        if (this.fMethodStubs != null) {
            int i = 0;
            while (i < this.fMethodStubs.length) {
                IMethodStub stub = this.fMethodStubs[i];
                if (!(stub.getAccess() != access || skipInline && stub.isInline())) {
                    list.add(stub);
                }
                ++i;
            }
        }
        return list;
    }

    private void addBaseClassInheritance(StringBuffer text) {
        if (this.fBaseClasses != null && this.fBaseClasses.length > 0) {
            text.append(" : ");
            int i = 0;
            while (i < this.fBaseClasses.length) {
                IBaseClassInfo baseClass = this.fBaseClasses[i];
                String baseClassName = baseClass.getType().getQualifiedTypeName().getFullyQualifiedName();
                if (i > 0) {
                    text.append(", ");
                }
                if (baseClass.getAccess() == ASTAccessVisibility.PRIVATE) {
                    text.append("private");
                } else if (baseClass.getAccess() == ASTAccessVisibility.PROTECTED) {
                    text.append("private");
                } else {
                    text.append("public");
                }
                text.append(' ');
                if (baseClass.isVirtual()) {
                    text.append("virtual ");
                }
                text.append(baseClassName);
                ++i;
            }
        }
    }

    private void addBaseClassIncludes(ITranslationUnit headerTU, StringBuffer text, String lineDelimiter, IProgressMonitor monitor) throws CodeGeneratorException {
        List<IPath> newIncludePaths;
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header_includePaths, 100);
        ICProject cProject = headerTU.getCProject();
        IProject project = cProject.getProject();
        Path projectLocation = new Path(project.getLocationURI().getPath());
        Path headerLocation = new Path(headerTU.getResource().getLocationURI().getPath());
        List<IPath> includePaths = this.getIncludePaths(headerTU);
        List<IPath> baseClassPaths = this.getBaseClassPaths(this.verifyBaseClasses());
        if (this.createIncludePaths() && !(newIncludePaths = this.getMissingIncludePaths((IPath)projectLocation, includePaths, baseClassPaths)).isEmpty()) {
            this.addIncludePaths(cProject, newIncludePaths, monitor);
        }
        ArrayList<IPath> systemIncludes = new ArrayList<IPath>();
        ArrayList<IPath> localIncludes = new ArrayList<IPath>();
        for (IPath baseClassLocation : baseClassPaths) {
            boolean isSystemIncludePath = false;
            IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)baseClassLocation, (IProject)project);
            if (includePath != null && !projectLocation.isPrefixOf(baseClassLocation)) {
                isSystemIncludePath = true;
            } else if (projectLocation.isPrefixOf(baseClassLocation) && projectLocation.isPrefixOf((IPath)headerLocation)) {
                includePath = PathUtil.makeRelativePath((IPath)baseClassLocation, (IPath)headerLocation.removeLastSegments(1));
            }
            if (includePath == null) {
                includePath = baseClassLocation;
            }
            includePath = includePath.removeFirstSegments(includePath.segmentCount() - 1).setDevice(null);
            if (isSystemIncludePath) {
                systemIncludes.add(includePath);
                continue;
            }
            localIncludes.add(includePath);
        }
        for (IPath includePath : systemIncludes) {
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            String include = this.getIncludeString(includePath.toString(), true);
            text.append(include);
            text.append(lineDelimiter);
        }
        for (IPath includePath : localIncludes) {
            if (headerTU.getElementName().equals(includePath.toString())) continue;
            String include = this.getIncludeString(includePath.toString(), false);
            text.append(include);
            text.append(lineDelimiter);
        }
        monitor.done();
    }

    private boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    private boolean createIncludePaths() {
        return NewClassWizardPrefs.createIncludePaths();
    }

    private void addIncludePaths(ICProject cProject, List<IPath> newIncludePaths, IProgressMonitor monitor) throws CodeGeneratorException {
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_header_addIncludePaths, 100);
        IPath addToResourcePath = cProject.getPath();
        try {
            ArrayList<Object> pathEntryList = new ArrayList<Object>();
            ArrayList<IPathEntry> checkEntryList = new ArrayList<IPathEntry>();
            IPathEntry[] checkEntries = cProject.getResolvedPathEntries();
            IPathEntry[] pathEntries = cProject.getRawPathEntries();
            if (pathEntries != null) {
                int i = 0;
                while (i < pathEntries.length) {
                    pathEntryList.add(pathEntries[i]);
                    ++i;
                }
            }
            IPathEntry[] iPathEntryArray = checkEntries;
            int n = checkEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry checkEntrie = iPathEntryArray[n2];
                if (checkEntrie instanceof IIncludeEntry) {
                    checkEntryList.add(checkEntrie);
                }
                ++n2;
            }
            for (IPath folderToAdd : newIncludePaths) {
                IIncludeEntry entry;
                ICProject includeProject;
                if (cProject.getPath().segment(0).equals(folderToAdd.segment(0)) || (includeProject = this.toCProject(PathUtil.getEnclosingProject((IPath)folderToAdd))) == null || checkEntryList.contains(entry = CoreModel.newIncludeEntry((IPath)addToResourcePath, null, (IPath)new Path(includeProject.getProject().getLocationURI().getPath()), (boolean)true))) continue;
                pathEntryList.add(entry);
            }
            pathEntries = pathEntryList.toArray(new IPathEntry[pathEntryList.size()]);
            cProject.setRawPathEntries(pathEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
        catch (CModelException e) {
            throw new CodeGeneratorException(e);
        }
        monitor.done();
    }

    private ICProject toCProject(IProject enclosingProject) {
        if (enclosingProject != null) {
            return CoreModel.getDefault().create(enclosingProject);
        }
        return null;
    }

    private List<IPath> getMissingIncludePaths(IPath projectLocation, List<IPath> includePaths, List<IPath> baseClassPaths) {
        ArrayList<IPath> newIncludePaths = new ArrayList<IPath>();
        for (IPath baseClassLocation : baseClassPaths) {
            if (projectLocation.isPrefixOf(baseClassLocation)) continue;
            IPath folderToAdd = baseClassLocation.removeLastSegments(1);
            IPath canonPath = PathUtil.getCanonicalPath((IPath)folderToAdd);
            if (canonPath != null) {
                folderToAdd = canonPath;
            }
            for (IPath newFolder : newIncludePaths) {
                if (!newFolder.isPrefixOf(folderToAdd)) continue;
                folderToAdd = null;
                break;
            }
            if (folderToAdd == null) continue;
            boolean foundPath = false;
            for (IPath includePath : includePaths) {
                if (!includePath.isPrefixOf(folderToAdd) && !includePath.equals((Object)folderToAdd)) continue;
                foundPath = true;
                break;
            }
            if (foundPath) continue;
            Iterator newIter = newIncludePaths.iterator();
            while (newIter.hasNext()) {
                IPath newFolder = (IPath)newIter.next();
                if (!folderToAdd.isPrefixOf(newFolder)) continue;
                newIter.remove();
            }
            if (newIncludePaths.contains(folderToAdd)) continue;
            newIncludePaths.add(folderToAdd);
        }
        return newIncludePaths;
    }

    private List<IPath> getIncludePaths(ITranslationUnit headerTU) throws CodeGeneratorException {
        String[] includePaths;
        IScannerInfo info;
        IProject project = headerTU.getCProject().getProject();
        ICContainer sourceFolder = CModelUtil.getSourceFolder((ICElement)headerTU);
        if (sourceFolder == null) {
            throw new CodeGeneratorException("Could not find source folder");
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (info = provider.getScannerInformation(sourceFolder.getResource())) != null && (includePaths = info.getIncludePaths()) != null) {
            ArrayList<IPath> list = new ArrayList<IPath>();
            int i = 0;
            while (i < includePaths.length) {
                Path path = new Path(includePaths[i]);
                if (!list.contains(path)) {
                    list.add((IPath)path);
                }
                ++i;
            }
            return list;
        }
        return null;
    }

    private List<IPath> getBaseClassPaths(boolean verifyLocation) throws CodeGeneratorException {
        ArrayList<IPath> list = new ArrayList<IPath>();
        int i = 0;
        while (i < this.fBaseClasses.length) {
            IBaseClassInfo baseClass = this.fBaseClasses[i];
            ITypeReference ref = baseClass.getType().getResolvedReference();
            IPath baseClassLocation = null;
            if (ref != null) {
                baseClassLocation = ref.getLocation();
            }
            if (baseClassLocation == null) {
                if (verifyLocation) {
                    throw new CodeGeneratorException("Could not find base class " + baseClass.toString());
                }
            } else if (!list.contains(baseClassLocation)) {
                list.add(baseClassLocation);
            }
            ++i;
        }
        return list;
    }

    public String constructSourceFileContent(ITranslationUnit sourceTU, ITranslationUnit headerTU, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, String oldContents, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NewClassWizardMessages.NewClassCodeGeneration_createType_task_source, 150);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)sourceTU);
        if (oldContents != null && oldContents.length() == 0) {
            oldContents = null;
        }
        StringBuffer text = new StringBuffer();
        String includeString = null;
        if (headerTU != null && (includeString = this.getHeaderIncludeString(sourceTU, headerTU, text, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) != null && oldContents != null && this.hasInclude(oldContents, includeString)) {
            includeString = null;
        }
        if (includeString != null) {
            if (oldContents != null) {
                int insertionPos = this.getIncludeInsertionPos(oldContents);
                if (insertionPos == -1) {
                    text.append(oldContents);
                    text.append(lineDelimiter);
                    text.append(includeString);
                    text.append(lineDelimiter);
                } else {
                    text.append(oldContents.substring(0, insertionPos));
                    text.append(includeString);
                    text.append(lineDelimiter);
                    text.append(oldContents.substring(insertionPos));
                }
            } else {
                text.append(includeString);
                text.append(lineDelimiter);
            }
            text.append(lineDelimiter);
        } else if (oldContents != null) {
            text.append(oldContents);
            text.append(lineDelimiter);
        }
        if (!(publicMethods.isEmpty() && protectedMethods.isEmpty() && privateMethods.isEmpty())) {
            if (this.fNamespace != null) {
                this.beginNamespace(text, lineDelimiter);
            }
            this.addMethodBodies(sourceTU, publicMethods, protectedMethods, privateMethods, text, lineDelimiter, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (this.fNamespace != null) {
                this.endNamespace(text, lineDelimiter);
            }
        }
        String fileContent = oldContents != null ? text.toString() : CodeGeneration.getBodyFileContent(sourceTU, null, text.toString(), lineDelimiter);
        monitor.done();
        return fileContent;
    }

    private String getHeaderIncludeString(ITranslationUnit sourceTU, ITranslationUnit headerTU, StringBuffer text, IProgressMonitor monitor) {
        IProject project = headerTU.getCProject().getProject();
        Path projectLocation = new Path(project.getLocationURI().getPath());
        Path headerLocation = new Path(headerTU.getResource().getLocationURI().getPath());
        Path sourceLocation = new Path(sourceTU.getResource().getLocationURI().getPath());
        IPath includePath = PathUtil.makeRelativePathToProjectIncludes((IPath)headerLocation, (IProject)project);
        boolean isSystemIncludePath = false;
        if (includePath != null && !projectLocation.isPrefixOf((IPath)headerLocation)) {
            isSystemIncludePath = true;
        } else if (projectLocation.isPrefixOf((IPath)headerLocation) && projectLocation.isPrefixOf((IPath)sourceLocation)) {
            includePath = PathUtil.makeRelativePath((IPath)headerLocation, (IPath)sourceLocation.removeLastSegments(1));
        }
        if (includePath == null) {
            includePath = headerLocation;
        }
        return this.getIncludeString(includePath.toString(), isSystemIncludePath);
    }

    private boolean hasInclude(String contents, String include) {
        int maxStartPos = contents.length() - include.length() - 1;
        if (maxStartPos < 0) {
            return false;
        }
        int startPos = 0;
        while (startPos <= maxStartPos) {
            int includePos = contents.indexOf(include, startPos);
            if (includePos == -1) {
                return false;
            }
            if (includePos == startPos) {
                return true;
            }
            int linePos = this.findFirstLineChar(contents, includePos);
            if (linePos == -1 || linePos == includePos) {
                return true;
            }
            boolean badLine = false;
            int pos = linePos;
            while (pos < includePos) {
                char c = contents.charAt(pos);
                if (!Character.isWhitespace(c)) {
                    badLine = true;
                    break;
                }
                ++pos;
            }
            if (!badLine) {
                return true;
            }
            startPos = includePos + include.length();
        }
        return false;
    }

    private int getIncludeInsertionPos(String contents) {
        int insertPos;
        int startPos;
        int eolPos;
        if (contents.length() == 0) {
            return -1;
        }
        int includePos = contents.lastIndexOf("#include ");
        if (includePos != -1 && (eolPos = this.findLastLineChar(contents, startPos = includePos + "#include ".length())) != -1 && (insertPos = eolPos + 1) < contents.length() - 1) {
            return insertPos;
        }
        return -1;
    }

    private void addMethodBodies(ITranslationUnit tu, List<IMethodStub> publicMethods, List<IMethodStub> protectedMethods, List<IMethodStub> privateMethods, StringBuffer text, String lineDelimiter, IProgressMonitor monitor) throws CoreException {
        String code;
        IMethodStub stub;
        Iterator<IMethodStub> i;
        if (!publicMethods.isEmpty()) {
            i = publicMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
        if (!protectedMethods.isEmpty()) {
            i = protectedMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
        if (!privateMethods.isEmpty()) {
            i = privateMethods.iterator();
            while (i.hasNext()) {
                stub = i.next();
                code = stub.createMethodImplementation(tu, this.fClassName, this.fBaseClasses, lineDelimiter);
                text.append(code);
                text.append(lineDelimiter);
                if (!i.hasNext()) continue;
                text.append(lineDelimiter);
            }
        }
    }

    private String getIncludeString(String fileName, boolean isSystemInclude) {
        StringBuffer buf = new StringBuffer();
        buf.append("#include ");
        if (isSystemInclude) {
            buf.append('<');
        } else {
            buf.append('\"');
        }
        buf.append(fileName);
        if (isSystemInclude) {
            buf.append('>');
        } else {
            buf.append('\"');
        }
        return buf.toString();
    }

    private int findLastLineChar(String contents, int startPos) {
        int endPos = contents.length() - 1;
        int linePos = startPos;
        while (linePos <= endPos) {
            char c = contents.charAt(linePos);
            if (c == '\r') {
                if (linePos < endPos && contents.charAt(linePos + 1) == '\n') {
                    return linePos + 1;
                }
                return linePos;
            }
            if (c == '\n') {
                return linePos;
            }
            ++linePos;
        }
        return -1;
    }

    private int findFirstLineChar(String contents, int startPos) {
        int linePos = startPos;
        while (linePos >= 0) {
            char c = contents.charAt(linePos);
            if (c == '\n' || c == '\r') {
                if (linePos + 1 < startPos) {
                    return linePos + 1;
                }
                return -1;
            }
            --linePos;
        }
        return -1;
    }

    public static class CodeGeneratorException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public CodeGeneratorException(String message) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, message, null));
        }

        public CodeGeneratorException(Throwable e) {
            super((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, e.getMessage(), e));
        }
    }
}

