/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.cdt.internal.ui.typehierarchy.ITHModelPresenter;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.THContentProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THHierarchyModel;
import org.eclipse.cdt.internal.ui.typehierarchy.THLabelProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.THNode;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.internal.ui.viewsupport.EditorOpener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class THInformationControl
extends AbstractInformationControl
implements ITHModelPresenter {
    private THHierarchyModel fModel;
    private THLabelProvider fHierarchyLabelProvider;
    private TreeViewer fHierarchyTreeViewer;
    private boolean fDisposed = false;

    public THInformationControl(Shell parent, int shellStyle, int treeStyle) {
        super(parent, shellStyle, treeStyle, "org.eclipse.cdt.ui.edit.open.quick.type.hierarchy", true);
    }

    protected boolean hasHeader() {
        return true;
    }

    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Display display = this.getShell().getDisplay();
        this.fModel = new THHierarchyModel(this, display);
        this.fHierarchyLabelProvider = new THLabelProvider(display, this.fModel);
        this.fHierarchyLabelProvider.setMarkImplementers(false);
        this.fHierarchyTreeViewer = new TreeViewer(parent, 2816);
        this.fHierarchyTreeViewer.setContentProvider((IContentProvider)new THContentProvider());
        this.fHierarchyTreeViewer.setLabelProvider((IBaseLabelProvider)this.fHierarchyLabelProvider);
        this.fHierarchyTreeViewer.setSorter(new ViewerSorter());
        this.fHierarchyTreeViewer.setUseHashlookup(true);
        return this.fHierarchyTreeViewer;
    }

    protected void onOpenElement(ISelection selection) {
        ICElement elem = (ICElement)this.getSelectedElement();
        if (elem != null) {
            try {
                EditorOpener.open(CUIPlugin.getActivePage(), elem);
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public void setInput(Object input) {
        ICElement[] splitInput;
        if (input instanceof ICElement[] && TypeHierarchyUI.isValidTypeInput((splitInput = (ICElement[])input)[0])) {
            this.fModel.setInput(splitInput[0], splitInput[1]);
            this.fHierarchyLabelProvider.setHideNonImplementers(splitInput[1] != null);
            this.fHierarchyTreeViewer.setInput((Object)this.fModel);
            this.fModel.computeGraph();
            String msgfmt = Messages.THInformationControl_regularTitle;
            String obj = splitInput[0].getElementName();
            if (splitInput[1] != null) {
                msgfmt = Messages.THInformationControl_showDefiningTypesTitle;
                obj = splitInput[1].getElementName();
            }
            String title = MessageFormat.format((String)msgfmt, (Object[])new Object[]{obj});
            this.setTitleText(title);
        }
    }

    protected String getId() {
        return "org.eclipse.cdt.internal.ui.typehierarchy.QuickHierarchy";
    }

    protected Object getSelectedElement() {
        THNode node = this.selectionToNode(this.fHierarchyTreeViewer.getSelection());
        if (node != null) {
            ICElement elem = node.getElement();
            if (node.isImplementor()) {
                this.fModel.onHierarchySelectionChanged(node);
                ICElement melem = this.fModel.getSelectedMember();
                if (melem != null) {
                    return melem;
                }
            }
            return elem;
        }
        return null;
    }

    private THNode selectionToNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object cand : ss) {
                if (!(cand instanceof THNode)) continue;
                return (THNode)cand;
            }
        }
        return null;
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fDisposed = true;
        super.widgetDisposed(event);
    }

    public void onEvent(int event) {
        if (!this.fDisposed) {
            switch (event) {
                case 0: {
                    if (this.fModel.hasTrivialHierarchy()) {
                        this.fHierarchyLabelProvider.setHideNonImplementers(false);
                    }
                    this.fHierarchyTreeViewer.refresh();
                    THNode selection = this.fModel.getSelectionInHierarchy();
                    if (selection == null) break;
                    this.fHierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                    this.fHierarchyTreeViewer.expandToLevel((Object)selection, 1);
                }
            }
        }
    }

    public void setMessage(String msg) {
    }

    public IWorkbenchSiteProgressService getProgressService() {
        return null;
    }

    protected void selectFirstMatch() {
        Tree tree = this.fHierarchyTreeViewer.getTree();
        THNode element = this.findElement(tree.getItems());
        if (element != null) {
            this.fHierarchyTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fHierarchyTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private THNode findElement(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            Object item = items[i].getData();
            THNode element = null;
            if (item instanceof THNode) {
                element = (THNode)item;
                if (this.fStringMatcher == null) {
                    return element;
                }
                String label = this.fHierarchyLabelProvider.getText(element);
                if (this.fStringMatcher.match(label)) {
                    return element;
                }
            }
            if ((element = this.findElement(items[i].getItems())) != null) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

