/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionAssistant;
import org.eclipse.cdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionContext;
import org.eclipse.cdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.cdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.cdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.cdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.cdt.internal.ui.text.correction.proposals.ChangeCorrectionProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.IInvocationContext;
import org.eclipse.cdt.ui.text.IProblemLocation;
import org.eclipse.cdt.ui.text.IQuickAssistProcessor;
import org.eclipse.cdt.ui.text.IQuickFixProcessor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCorrectionProcessor
implements org.eclipse.jface.text.quickassist.IQuickAssistProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fgContributedAssistProcessors = null;
    private static ContributedProcessorDescriptor[] fgContributedCorrectionProcessors = null;
    private CCorrectionAssistant fAssistant;
    private String fErrorMessage;

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String contributionId, boolean testMarkerTypes) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.ui", contributionId);
        ArrayList<ContributedProcessorDescriptor> res = new ArrayList<ContributedProcessorDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ContributedProcessorDescriptor desc = new ContributedProcessorDescriptor(elements[i], testMarkerTypes);
            IStatus status = desc.checkSyntax();
            if (status.isOK()) {
                res.add(desc);
            } else {
                CUIPlugin.log(status);
            }
            ++i;
        }
        return res.toArray(new ContributedProcessorDescriptor[res.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fgContributedCorrectionProcessors == null) {
            fgContributedCorrectionProcessors = CCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID, true);
        }
        return fgContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fgContributedAssistProcessors == null) {
            fgContributedAssistProcessors = CCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID, false);
        }
        return fgContributedAssistProcessors;
    }

    public static boolean hasCorrections(ITranslationUnit tu, int problemId, String markerType) {
        ContributedProcessorDescriptor[] processors = CCorrectionProcessor.getCorrectionProcessors();
        SafeHasCorrections collector = new SafeHasCorrections(tu, problemId);
        int i = 0;
        while (i < processors.length) {
            if (processors[i].canHandleMarkerType(markerType)) {
                collector.process(processors[i]);
                if (collector.hasCorrections()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof ICAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        ITranslationUnit tu;
        ICAnnotation cAnnotation;
        int problemId;
        if (annotation instanceof ICAnnotation && (problemId = (cAnnotation = (ICAnnotation)annotation).getId()) != -1 && (tu = cAnnotation.getTranslationUnit()) != null) {
            return CCorrectionProcessor.hasCorrections(tu, problemId, cAnnotation.getMarkerType());
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return CCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(CorrectionContext context) {
        ContributedProcessorDescriptor[] processors = CCorrectionProcessor.getAssistProcessors();
        SafeHasAssist collector = new SafeHasAssist(context);
        int i = 0;
        while (i < processors.length) {
            collector.process(processors[i]);
            if (collector.hasAssists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CCorrectionProcessor(CCorrectionAssistant assistant) {
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                CCorrectionProcessor.this.fAssistant.setStatusLineVisible(false);
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                CCorrectionProcessor.this.fAssistant.setStatusLineVisible(true);
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                if (proposal instanceof IStatusLineProposal) {
                    IStatusLineProposal statusLineProposal = (IStatusLineProposal)proposal;
                    String message = statusLineProposal.getStatusMessage();
                    if (message != null) {
                        CCorrectionProcessor.this.fAssistant.setStatusMessage(message);
                    } else {
                        CCorrectionProcessor.this.fAssistant.setStatusMessage("");
                    }
                } else {
                    CCorrectionProcessor.this.fAssistant.setStatusMessage("");
                }
            }
        });
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        IEditorPart part = this.fAssistant.getEditor();
        IWorkingCopy tu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(part.getEditorInput());
        IAnnotationModel model = CUIPlugin.getDefault().getDocumentProvider().getAnnotationModel(part.getEditorInput());
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        CorrectionContext context = new CorrectionContext((ITranslationUnit)tu, viewer, documentOffset, length);
        Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
        this.fErrorMessage = null;
        ICompletionProposal[] res = null;
        if (model != null && annotations != null) {
            ArrayList<ICCompletionProposal> proposals = new ArrayList<ICCompletionProposal>(10);
            IStatus status = CCorrectionProcessor.collectProposals(context, model, annotations, true, !this.fAssistant.isUpdatedOffset(), proposals);
            res = proposals.toArray(new ICCompletionProposal[proposals.size()]);
            if (!status.isOK()) {
                this.fErrorMessage = status.getMessage();
                CUIPlugin.log(status);
            }
        }
        if (res == null || res.length == 0) {
            return new ICCompletionProposal[]{new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (res.length > 1) {
            Arrays.sort(res, new CCompletionProposalComparator());
        }
        return res;
    }

    public static IStatus collectProposals(CorrectionContext context, IAnnotationModel model, Annotation[] annotations, boolean addQuickFixes, boolean addQuickAssists, Collection<ICCompletionProposal> proposals) {
        IStatus status;
        ArrayList<ProblemLocation> problems = new ArrayList<ProblemLocation>();
        int i = 0;
        while (i < annotations.length) {
            ProblemLocation problemLocation;
            Annotation curr = annotations[i];
            if (curr instanceof ICAnnotation && (problemLocation = CCorrectionProcessor.getProblemLocation((ICAnnotation)curr, model)) != null) {
                problems.add(problemLocation);
            }
            if (addQuickFixes && curr instanceof SimpleMarkerAnnotation) {
                CCorrectionProcessor.collectMarkerProposals((SimpleMarkerAnnotation)curr, proposals);
            }
            ++i;
        }
        MultiStatus resStatus = null;
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        if (addQuickFixes && !(status = CCorrectionProcessor.collectCorrections(context, problemLocations, proposals)).isOK()) {
            resStatus = new MultiStatus("org.eclipse.cdt.ui", 4, CorrectionMessages.CCorrectionProcessor_error_quickfix_message, null);
            resStatus.add(status);
        }
        if (addQuickAssists && !(status = CCorrectionProcessor.collectAssists(context, problemLocations, proposals)).isOK()) {
            if (resStatus == null) {
                resStatus = new MultiStatus("org.eclipse.cdt.ui", 4, CorrectionMessages.CCorrectionProcessor_error_quickassist_message, null);
            }
            resStatus.add(status);
        }
        if (resStatus != null) {
            return resStatus;
        }
        return Status.OK_STATUS;
    }

    private static ProblemLocation getProblemLocation(ICAnnotation cAnnotation, IAnnotationModel model) {
        Position pos;
        int problemId = cAnnotation.getId();
        if (problemId != -1 && (pos = model.getPosition((Annotation)cAnnotation)) != null) {
            return new ProblemLocation(pos.getOffset(), pos.getLength(), cAnnotation);
        }
        return null;
    }

    private static void collectMarkerProposals(SimpleMarkerAnnotation annotation, Collection<ICCompletionProposal> proposals) {
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
        if (res.length > 0) {
            int i = 0;
            while (i < res.length) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
    }

    public static IStatus collectCorrections(CorrectionContext context, IProblemLocation[] locations, Collection<ICCompletionProposal> proposals) {
        ContributedProcessorDescriptor[] processors = CCorrectionProcessor.getCorrectionProcessors();
        SafeCorrectionCollector collector = new SafeCorrectionCollector(context, proposals);
        int i = 0;
        while (i < processors.length) {
            ContributedProcessorDescriptor curr = processors[i];
            IProblemLocation[] handled = CCorrectionProcessor.getHandledProblems(locations, curr);
            if (handled != null) {
                collector.setProblemLocations(handled);
                collector.process(curr);
            }
            ++i;
        }
        return collector.getStatus();
    }

    private static IProblemLocation[] getHandledProblems(IProblemLocation[] locations, ContributedProcessorDescriptor processor) {
        boolean allHandled = true;
        ArrayList<IProblemLocation> res = null;
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            if (processor.canHandleMarkerType(curr.getMarkerType())) {
                if (!allHandled) {
                    if (res == null) {
                        res = new ArrayList<IProblemLocation>(locations.length - i);
                    }
                    res.add(curr);
                }
            } else if (allHandled) {
                if (i > 0) {
                    res = new ArrayList(locations.length - i);
                    int k = 0;
                    while (k < i) {
                        res.add(locations[k]);
                        ++k;
                    }
                }
                allHandled = false;
            }
            ++i;
        }
        if (allHandled) {
            return locations;
        }
        if (res == null) {
            return null;
        }
        return res.toArray(new IProblemLocation[res.size()]);
    }

    public static IStatus collectAssists(CorrectionContext context, IProblemLocation[] locations, Collection<ICCompletionProposal> proposals) {
        ContributedProcessorDescriptor[] processors = CCorrectionProcessor.getAssistProcessors();
        SafeAssistCollector collector = new SafeAssistCollector(context, locations, proposals);
        collector.process(processors);
        return collector.getStatus();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return CCorrectionProcessor.hasCorrections(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        if (invocationContext instanceof CorrectionContext) {
            return CCorrectionProcessor.hasAssists((CorrectionContext)invocationContext);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SafeAssistCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final IProblemLocation[] fLocations;
        private final Collection<ICCompletionProposal> fProposals;

        public SafeAssistCollector(IInvocationContext context, IProblemLocation[] locations, Collection<ICCompletionProposal> proposals) {
            this.fContext = context;
            this.fLocations = locations;
            this.fProposals = proposals;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            ICCompletionProposal[] res;
            IQuickAssistProcessor curr = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getTranslationUnit());
            if (curr != null && (res = curr.getAssists(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SafeCorrectionCollector
    extends SafeCorrectionProcessorAccess {
        private final CorrectionContext fContext;
        private final Collection<ICCompletionProposal> fProposals;
        private IProblemLocation[] fLocations;

        public SafeCorrectionCollector(CorrectionContext context, Collection<ICCompletionProposal> proposals) {
            this.fContext = context;
            this.fProposals = proposals;
        }

        public void setProblemLocations(IProblemLocation[] locations) {
            this.fLocations = locations;
        }

        @Override
        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            ICCompletionProposal[] res;
            IQuickFixProcessor curr = (IQuickFixProcessor)desc.getProcessor(this.fContext.getTranslationUnit());
            if (curr != null && (res = curr.getCorrections(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    private static abstract class SafeCorrectionProcessorAccess
    implements ISafeRunnable {
        private MultiStatus fMulti = null;
        private ContributedProcessorDescriptor fDescriptor;

        private SafeCorrectionProcessorAccess() {
        }

        public void process(ContributedProcessorDescriptor[] desc) {
            int i = 0;
            while (i < desc.length) {
                this.fDescriptor = desc[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
        }

        public void process(ContributedProcessorDescriptor desc) {
            this.fDescriptor = desc;
            SafeRunner.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.safeRun(this.fDescriptor);
        }

        protected abstract void safeRun(ContributedProcessorDescriptor var1) throws Exception;

        public void handleException(Throwable exception) {
            if (this.fMulti == null) {
                this.fMulti = new MultiStatus("org.eclipse.cdt.ui", 0, CorrectionMessages.CCorrectionProcessor_error_status, null);
            }
            this.fMulti.merge((IStatus)new Status(4, "org.eclipse.cdt.ui", 4, CorrectionMessages.CCorrectionProcessor_error_status, exception));
        }

        public IStatus getStatus() {
            if (this.fMulti == null) {
                return Status.OK_STATUS;
            }
            return this.fMulti;
        }
    }

    private static class SafeHasAssist
    extends SafeCorrectionProcessorAccess {
        private final CorrectionContext fContext;
        private boolean fHasAssists;

        public SafeHasAssist(CorrectionContext context) {
            this.fContext = context;
            this.fHasAssists = false;
        }

        public boolean hasAssists() {
            return this.fHasAssists;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickAssistProcessor processor = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getTranslationUnit());
            if (processor != null && processor.hasAssists(this.fContext)) {
                this.fHasAssists = true;
            }
        }
    }

    private static class SafeHasCorrections
    extends SafeCorrectionProcessorAccess {
        private final ITranslationUnit fCu;
        private final int fProblemId;
        private boolean fHasCorrections;

        public SafeHasCorrections(ITranslationUnit tu, int problemId) {
            this.fCu = tu;
            this.fProblemId = problemId;
            this.fHasCorrections = false;
        }

        public boolean hasCorrections() {
            return this.fHasCorrections;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickFixProcessor processor = (IQuickFixProcessor)desc.getProcessor(this.fCu);
            if (processor != null && processor.hasCorrections(this.fCu, this.fProblemId)) {
                this.fHasCorrections = true;
            }
        }
    }
}

