/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.CommentContextType;
import org.eclipse.cdt.internal.corext.template.c.DocCommentContextType;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContextType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompletionProposalComputer
implements ICompletionProposalComputer {
    private final TemplateEngine fCTemplateEngine;
    private final TemplateEngine fCommentTemplateEngine;
    private final TemplateEngine fDocCommentTemplateEngine;

    public TemplateCompletionProposalComputer() {
        TemplateContextType contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.c");
        if (contextType == null) {
            contextType = new CContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fCTemplateEngine = new TemplateEngine(contextType);
        contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.comment");
        if (contextType == null) {
            contextType = new CommentContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fCommentTemplateEngine = new TemplateEngine(contextType);
        contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.doccomment");
        if (contextType == null) {
            contextType = new DocCommentContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fDocCommentTemplateEngine = new TemplateEngine(contextType);
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ITextViewer viewer = context.getViewer();
        int offset = context.getInvocationOffset();
        TemplateEngine engine = null;
        try {
            String partition = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"___c_partitioning", (int)offset, (boolean)true);
            if (partition.equals("__c_multiline_comment") || partition.equals("__c_singleline_comment")) {
                engine = this.fCommentTemplateEngine;
            } else if (partition.equals("__c_multiline_doc_comment") || partition.equals("__c_singleline_doc_comment")) {
                engine = this.fDocCommentTemplateEngine;
            } else if (this.isValidContext(context)) {
                engine = this.fCTemplateEngine;
            }
        }
        catch (BadLocationException badLocationException) {
            return Collections.emptyList();
        }
        if (engine != null && context instanceof CContentAssistInvocationContext) {
            CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
            ITranslationUnit tUnit = cContext.getTranslationUnit();
            if (tUnit == null) {
                return Collections.emptyList();
            }
            engine.reset();
            engine.complete(viewer, offset, tUnit);
            List<ICompletionProposal> result = engine.getResults();
            return result;
        }
        return Collections.emptyList();
    }

    private boolean isValidContext(ContentAssistInvocationContext context) {
        int start;
        CHeuristicScanner scanner = new CHeuristicScanner(context.getDocument());
        return !scanner.looksLikeFieldReferenceBackward(start = context.getInvocationOffset(), Math.max(0, start - 100));
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sessionStarted() {
    }

    @Override
    public void sessionEnded() {
        if (this.fCommentTemplateEngine != null) {
            this.fCommentTemplateEngine.reset();
        }
        if (this.fCTemplateEngine != null) {
            this.fCTemplateEngine.reset();
        }
    }
}

