/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;

public class CRefactoringArgument {
    private int fOffset = 0;
    private int fLength = 0;
    private String fText = "";
    private int fKind = 0;
    private IFile fFile;
    private IBinding fBinding;
    private IScope fScope;
    private IASTTranslationUnit fTranslationUnit;

    public CRefactoringArgument(IFile file, int offset, int length) {
        this.fFile = file;
        this.fOffset = offset;
        this.fLength = length;
    }

    public CRefactoringArgument(ICElement elem) {
        if (elem instanceof ISourceReference) {
            ISourceReference sref = (ISourceReference)elem;
            try {
                ISourceRange sr = sref.getSourceRange();
                this.fFile = (IFile)sref.getTranslationUnit().getResource();
                this.fOffset = sr.getIdStartPos();
                this.fLength = sr.getIdLength();
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    public String getName() {
        return this.fText;
    }

    public IFile getSourceFile() {
        return this.fFile;
    }

    public int getArgumentKind() {
        return this.fKind;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setName(IASTName name) {
        this.fText = name.toString();
    }

    public void setBinding(IASTTranslationUnit tu, IBinding binding, IScope scope) {
        this.fTranslationUnit = tu;
        this.fBinding = binding;
        this.fScope = scope;
        if (binding instanceof IVariable) {
            IVariable var = (IVariable)binding;
            if (binding instanceof IField) {
                this.fKind = 5;
            } else if (binding instanceof IParameter) {
                this.fKind = 2;
            } else if (ASTManager.isLocalVariable(var, scope)) {
                this.fKind = 1;
            } else {
                boolean isStatic = false;
                try {
                    isStatic = var.isStatic();
                }
                catch (DOMException dOMException) {}
                this.fKind = isStatic ? 3 : 4;
            }
        } else if (binding instanceof IEnumerator) {
            this.fKind = 13;
        } else if (binding instanceof IFunction) {
            this.fKind = 9;
            IFunction func = (IFunction)binding;
            if (binding instanceof ICPPMethod) {
                ICPPMethod method = (ICPPMethod)binding;
                int isVirtual = -1;
                try {
                    isVirtual = ASTManager.isVirtualMethod(method);
                }
                catch (DOMException dOMException) {}
                if (isVirtual == 1) {
                    this.fKind = 8;
                }
            } else {
                boolean isStatic = false;
                try {
                    isStatic = func.isStatic();
                }
                catch (DOMException dOMException) {}
                this.fKind = isStatic ? 6 : 7;
            }
        } else if (binding instanceof ICompositeType) {
            this.fKind = 14;
        } else if (binding instanceof IEnumeration || binding instanceof ITypedef) {
            this.fKind = 10;
        } else if (binding instanceof ICPPNamespace) {
            this.fKind = 15;
        } else if (binding instanceof IMacroBinding) {
            this.fKind = 11;
        }
    }

    public IScope getScope() {
        return this.fScope;
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.fTranslationUnit;
    }
}

