/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.dialogs;

import org.eclipse.cdt.internal.ui.refactoring.NameNVisibilityInformation;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.Messages;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.NameAndVisibilityComposite;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ExtractInputPage
extends UserInputWizardPage {
    protected NameAndVisibilityComposite control;
    protected NameNVisibilityInformation info;
    protected String label = Messages.ExtractInputPage_ReplaceInSubclass;
    protected String errorLabel = Messages.ExtractInputPage_EnterName;

    public ExtractInputPage(String name, NameNVisibilityInformation info) {
        super(name);
        this.info = info;
    }

    public void createControl(Composite parent) {
        this.control = new NameAndVisibilityComposite(parent, this.label, this.info.getName());
        this.setTitle(this.getName());
        this.setPageComplete(false);
        this.control.getConstantNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractInputPage.this.info.setName(ExtractInputPage.this.control.getConstantNameText().getText());
                ExtractInputPage.this.checkName();
            }
        });
        Control[] controlArray = this.control.getVisibiltyGroup().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttons = controlArray[n2];
            buttons.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    String text = ((Button)e.getSource()).getText();
                    ExtractInputPage.this.visibilityChange(text);
                }
            });
            ++n2;
        }
        this.checkName();
        this.setControl((Control)this.control);
    }

    protected void checkName() {
        String methodName = this.control.getConstantNameText().getText();
        IdentifierResult result = IdentifierHelper.checkIdentifierName(methodName);
        if (result.isCorrect()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            this.verifyName(methodName);
        } else {
            this.setErrorMessage(NLS.bind((String)Messages.ExtractInputPage_CheckName, (Object)result.getMessage()));
            this.setPageComplete(false);
        }
    }

    protected abstract void verifyName(String var1);

    protected void visibilityChange(String visibilityText) {
        this.info.setVisibility(VisibilityEnum.getEnumForStringRepresentation(visibilityText));
    }
}

