/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.ui.preferences.IndexerPreferencePage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class IndexerStrategyBlock
extends AbstractCOptionPage {
    private Button fAutoUpdateButton;
    private Button fImmediateUpdateButton;
    private Button fUseActiveBuildButton;
    private Button fUseFixedBuildConfig;

    public IndexerStrategyBlock(ICOptionContainer container) {
        this.setContainer(container);
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite(parent, 1);
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.marginWidth = 0;
        gl.verticalSpacing = gl.marginHeight * 2;
        GridData gd = (GridData)composite.getLayoutData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 4;
        this.setControl((Control)composite);
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexerStrategyBlock.this.updateEnablement();
            }
        };
        Group group = ControlFactory.createGroup(composite, DialogsMessages.IndexerStrategyBlock_strategyGroup, 1);
        gd = (GridData)group.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.fAutoUpdateButton = ControlFactory.createCheckBox((Composite)group, DialogsMessages.IndexerStrategyBlock_autoUpdate);
        this.fImmediateUpdateButton = ControlFactory.createCheckBox((Composite)group, DialogsMessages.IndexerStrategyBlock_immediateUpdate);
        this.fAutoUpdateButton.addSelectionListener((SelectionListener)updateEnablement);
        if (IndexerPreferencePage.showBuildConfiguration()) {
            group = ControlFactory.createGroup(composite, DialogsMessages.IndexerStrategyBlock_buildConfigGroup, 1);
            gd = (GridData)group.getLayoutData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.fUseActiveBuildButton = ControlFactory.createRadioButton((Composite)group, DialogsMessages.IndexerStrategyBlock_activeBuildConfig, null, null);
            this.fUseFixedBuildConfig = ControlFactory.createRadioButton((Composite)group, DialogsMessages.IndexerStrategyBlock_specificBuildConfig, null, null);
        }
        this.initializeValues();
    }

    protected void updateEnablement() {
        this.fImmediateUpdateButton.setEnabled(this.fAutoUpdateButton.getSelection());
    }

    private void initializeValues() {
        int updatePolicy = IndexerPreferences.getUpdatePolicy(null);
        this.initUpdatePolicy(updatePolicy);
        if (this.fUseActiveBuildButton != null) {
            ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescriptionWorkspacePreferences prefs = prjDescMgr.getProjectDescriptionWorkspacePreferences(false);
            boolean useActive = prefs.getConfigurationRelations() == 2;
            this.fUseActiveBuildButton.setSelection(useActive);
            this.fUseFixedBuildConfig.setSelection(!useActive);
        }
        this.updateEnablement();
    }

    private void initUpdatePolicy(int updatePolicy) {
        this.fAutoUpdateButton.setSelection(updatePolicy != 2);
        this.fImmediateUpdateButton.setSelection(updatePolicy == 0);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        int updatePolicy = !this.fAutoUpdateButton.getSelection() ? 2 : (this.fImmediateUpdateButton.getSelection() ? 0 : 1);
        IndexerPreferences.setUpdatePolicy(null, (int)updatePolicy);
        if (this.fUseActiveBuildButton != null) {
            boolean useActive = this.fUseActiveBuildButton.getSelection();
            int relation = useActive ? 2 : 1;
            ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescriptionWorkspacePreferences prefs = prjDescMgr.getProjectDescriptionWorkspacePreferences(true);
            prefs.setConfigurationRelations(relation);
            prjDescMgr.setProjectDescriptionWorkspacePreferences(prefs, false, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void performDefaults() {
        this.initUpdatePolicy(IndexerPreferences.getDefaultUpdatePolicy());
        if (this.fUseActiveBuildButton != null) {
            this.fUseActiveBuildButton.setSelection(false);
            this.fUseFixedBuildConfig.setSelection(true);
        }
        this.updateEnablement();
    }
}

