/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class CNavigatorDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final IResource[] NO_RESOURCES = new IResource[0];

    public boolean isSupportedType(TransferData transferType) {
        return super.isSupportedType(transferType) || ResourceTransfer.getInstance().isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType);
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        try {
            if (target instanceof ICContainer || target instanceof ICProject || target instanceof IContainer || dropAdapter.getCurrentOperation() == 1 && (target instanceof IFile || target instanceof ITranslationUnit)) {
                Object data = event.data;
                if (data == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                final IContainer destination = this.getDestination(target);
                if (destination == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IResource[] resources = null;
                TransferData currentTransfer = dropAdapter.getCurrentTransfer();
                if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
                    resources = this.getSelectedResources();
                    if (target instanceof ITranslationUnit && this.handleDropCopy(target, event).isOK()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
                    resources = (IResource[])event.data;
                }
                if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
                    final String[] names = (String[])data;
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            CNavigatorDropAdapterAssistant.this.getShell().forceActive();
                            CopyFilesAndFoldersOperation op = new CopyFilesAndFoldersOperation(CNavigatorDropAdapterAssistant.this.getShell());
                            op.copyFiles(names, destination);
                        }
                    });
                } else if (event.detail == 1) {
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                    operation.copyResources(resources, destination);
                } else {
                    ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), "Move Resource Action", "Move Resource Action");
                    resources = checker.checkReadOnlyResources(resources);
                    MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
                    operation.copyResources(resources, destination);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            switch (event.detail) {
                case 2: {
                    IStatus iStatus = this.handleDropMove(target, event);
                    return iStatus;
                }
                case 1: {
                    IStatus iStatus = this.handleDropCopy(target, event);
                    return iStatus;
                }
            }
        }
        catch (CModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), CViewMessages.SelectionTransferDropAdapter_error_title, CViewMessages.SelectionTransferDropAdapter_error_message);
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, CViewMessages.SelectionTransferDropAdapter_error_title, CViewMessages.SelectionTransferDropAdapter_error_exception);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            event.detail = 0;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof ICContainer || target instanceof ICProject || target instanceof IContainer || operation == 1 && (target instanceof IFile || target instanceof ITranslationUnit)) {
            IContainer destination = this.getDestination(target);
            if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                IResource[] selectedResources = this.getSelectedResources();
                if (selectedResources.length > 0) {
                    CopyFilesAndFoldersOperation op;
                    IResource[] iResourceArray = selectedResources;
                    int n = selectedResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource res = iResourceArray[n2];
                        if (res instanceof IProject) {
                            return Status.CANCEL_STATUS;
                        }
                        ++n2;
                    }
                    if (operation == 1 ? (op = new CopyFilesAndFoldersOperation(this.getShell())).validateDestination(destination, selectedResources) == null : (op = new MoveFilesAndFoldersOperation(this.getShell())).validateDestination(destination, selectedResources) == null) {
                        return Status.OK_STATUS;
                    }
                }
            } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
                CopyFilesAndFoldersOperation copyOperation;
                String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
                if (sourceNames == null) {
                    sourceNames = new String[]{};
                }
                if ((copyOperation = new CopyFilesAndFoldersOperation(this.getShell())).validateImportDestination(destination, sourceNames) != null) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            try {
                switch (operation) {
                    case 16: {
                        return this.handleValidateMove(target);
                    }
                    case 1: {
                        return this.handleValidateCopy(target);
                    }
                    case 2: {
                        return this.handleValidateMove(target);
                    }
                }
            }
            catch (CModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), CViewMessages.SelectionTransferDropAdapter_error_title, CViewMessages.SelectionTransferDropAdapter_error_message);
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleValidateCopy(Object target) throws CModelException {
        if (target != null) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            ICElement[] cElements = CNavigatorDropAdapterAssistant.getCElements(selection);
            if (cElements == null || cElements.length == 0) {
                return Status.CANCEL_STATUS;
            }
            if (!CNavigatorDropAdapterAssistant.canCopyElements(cElements)) {
                return Status.CANCEL_STATUS;
            }
            if (target instanceof ISourceReference) {
                ICElement[] iCElementArray = cElements;
                int n = cElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement cElement = iCElementArray[n2];
                    if (cElement.getElementType() <= 60) {
                        return Status.CANCEL_STATUS;
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleValidateMove(Object target) throws CModelException {
        if (target != null) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            ICElement[] cElements = CNavigatorDropAdapterAssistant.getCElements(selection);
            if (cElements == null || cElements.length == 0) {
                return Status.CANCEL_STATUS;
            }
            if (Arrays.asList(cElements).contains(target)) {
                return Status.CANCEL_STATUS;
            }
            if (!CNavigatorDropAdapterAssistant.canMoveElements(cElements)) {
                return Status.CANCEL_STATUS;
            }
            if (target instanceof ISourceReference) {
                ICElement[] iCElementArray = cElements;
                int n = cElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement cElement = iCElementArray[n2];
                    if (cElement.getElementType() <= 60) {
                        return Status.CANCEL_STATUS;
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleDropCopy(Object target, DropTargetEvent event) throws CModelException, InvocationTargetException, InterruptedException {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        final ICElement[] cElements = CNavigatorDropAdapterAssistant.getCElements(selection);
        if (target instanceof ICElement && cElements.length > 0) {
            ICElement cTarget;
            ICElement parent = cTarget = (ICElement)target;
            boolean isTargetTranslationUnit = cTarget instanceof ITranslationUnit;
            if (!isTargetTranslationUnit) {
                parent = cTarget.getParent();
            }
            final ICElement[] containers = new ICElement[cElements.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = parent;
                ++i;
            }
            ICElement[] neighbours = null;
            if (!isTargetTranslationUnit) {
                neighbours = new ICElement[cElements.length];
                int i2 = 0;
                while (i2 < neighbours.length) {
                    neighbours[i2] = cTarget;
                    ++i2;
                }
            }
            final ICElement[] siblings = neighbours;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CoreModel.getDefault().getCModel().copy(cElements, containers, siblings, null, false, monitor);
                    }
                    catch (CModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.run(runnable);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleDropMove(Object target, DropTargetEvent event) throws CModelException, InvocationTargetException, InterruptedException {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        final ICElement[] cElements = CNavigatorDropAdapterAssistant.getCElements(selection);
        if (target instanceof ICElement) {
            ICElement cTarget;
            ICElement parent = cTarget = (ICElement)target;
            boolean isTargetTranslationUnit = cTarget instanceof ITranslationUnit;
            if (!isTargetTranslationUnit) {
                parent = cTarget.getParent();
            }
            final ICElement[] containers = new ICElement[cElements.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = parent;
                ++i;
            }
            ICElement[] neighbours = null;
            if (!isTargetTranslationUnit) {
                neighbours = new ICElement[cElements.length];
                int i2 = 0;
                while (i2 < neighbours.length) {
                    neighbours[i2] = cTarget;
                    ++i2;
                }
            }
            final ICElement[] siblings = neighbours;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CoreModel.getDefault().getCModel().move(cElements, containers, siblings, null, false, monitor);
                    }
                    catch (CModelException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.run(runnable);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void run(IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
        context.run(true, true, runnable);
    }

    public static ICElement[] getCElements(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        List elements = ((IStructuredSelection)selection).toList();
        ArrayList resources = new ArrayList(elements.size());
        for (Object element : elements) {
            if (element instanceof ITranslationUnit || !(element instanceof ICElement)) continue;
            resources.add(element);
        }
        return resources.toArray(new ICElement[resources.size()]);
    }

    private static boolean canCopyElements(ICElement[] cElements) {
        if (cElements != null) {
            return CNavigatorDropAdapterAssistant.hasCommonParent(cElements);
        }
        return false;
    }

    private static boolean canMoveElements(ICElement[] cElements) {
        if (cElements != null) {
            return CNavigatorDropAdapterAssistant.hasCommonParent(cElements);
        }
        return false;
    }

    private static boolean hasCommonParent(ICElement[] elements) {
        if (elements.length > 1) {
            ICElement parent = elements[0];
            int i = 0;
            while (i < elements.length) {
                ICElement p = elements[i].getParent();
                if (parent == null ? p != null : !parent.equals(p)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private IContainer getDestination(Object dropTarget) {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof ICElement) {
            return this.getDestination(((ICElement)dropTarget).getResource());
        }
        if (dropTarget instanceof IFile) {
            return ((IFile)dropTarget).getParent();
        }
        return null;
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return NO_RESOURCES;
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList selectedResources = new ArrayList();
        for (Object o : selection) {
            IAdaptable a;
            IResource r;
            if (o instanceof IResource) {
                selectedResources.add(o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }
}

