/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.language.LanguageMappingStore;
import org.eclipse.cdt.internal.ui.language.LanguageVerifier;
import org.eclipse.cdt.internal.ui.language.WorkspaceLanguageMappingWidget;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkspaceLanguageMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    WorkspaceLanguageConfiguration fMappings;
    WorkspaceLanguageMappingWidget fMappingWidget = new WorkspaceLanguageMappingWidget();

    protected Control createContents(Composite parent) {
        try {
            this.fetchMappings();
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return this.fMappingWidget.createContents(parent, PreferencesMessages.WorkspaceLanguagesPreferencePage_description);
    }

    private void fetchMappings() throws CoreException {
        this.fMappings = LanguageManager.getInstance().getWorkspaceLanguageConfiguration();
        Map<String, ILanguage> availableLanguages = LanguageVerifier.computeAvailableLanguages();
        Set<String> missingLanguages = LanguageVerifier.removeMissingLanguages(this.fMappings, availableLanguages);
        if (missingLanguages.size() > 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 40);
            messageBox.setText(PreferencesMessages.LanguageMappings_missingLanguageTitle);
            String affectedLanguages = LanguageVerifier.computeAffectedLanguages(missingLanguages);
            messageBox.setMessage(Messages.format(PreferencesMessages.WorkspaceLanguagesPreferencePage_missingLanguage, affectedLanguages));
            messageBox.open();
        }
        this.fMappingWidget.setMappings(this.fMappings.getWorkspaceMappings());
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        block3: {
            try {
                if (this.fMappingWidget.isChanged()) break block3;
                return true;
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return false;
            }
        }
        IContentType[] affectedContentTypes = this.fMappingWidget.getAffectedContentTypes();
        LanguageManager manager = LanguageManager.getInstance();
        WorkspaceLanguageConfiguration config = manager.getWorkspaceLanguageConfiguration();
        config.setWorkspaceMappings(this.fMappingWidget.getContentTypeMappings());
        manager.storeWorkspaceLanguageConfiguration(affectedContentTypes);
        this.fMappingWidget.setChanged(false);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences node = CCorePlugin.getDefault().getPluginPreferences();
        node.setToDefault("org.eclipse.cdt.core.workspaceLanguageMappings");
        try {
            String[] contentTypeIds;
            Map currentMappings = this.fMappings.getWorkspaceMappings();
            Set keys = currentMappings.keySet();
            String[] stringArray = contentTypeIds = keys.toArray(new String[keys.size()]);
            int n = contentTypeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contentTypeId = stringArray[n2];
                this.fMappings.removeWorkspaceMapping(contentTypeId);
                ++n2;
            }
            LanguageMappingStore store = new LanguageMappingStore();
            WorkspaceLanguageConfiguration defaultConfig = store.decodeWorkspaceMappings();
            Map defaultMappings = defaultConfig.getWorkspaceMappings();
            for (String contentTypeId : defaultMappings.keySet()) {
                String language = (String)defaultMappings.get(contentTypeId);
                this.fMappings.addWorkspaceMapping(contentTypeId, language);
            }
            this.fetchMappings();
            this.fMappingWidget.refreshMappings();
            this.fMappingWidget.setChanged(false);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }
}

