/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageVerifier {
    public static Map<String, ILanguage> computeAvailableLanguages() {
        ILanguage[] registeredLanguages = LanguageManager.getInstance().getRegisteredLanguages();
        TreeMap<String, ILanguage> languages = new TreeMap<String, ILanguage>();
        int i = 0;
        while (i < registeredLanguages.length) {
            languages.put(registeredLanguages[i].getId(), registeredLanguages[i]);
            ++i;
        }
        return languages;
    }

    public static String computeAffectedLanguages(Set<String> missingLanguages) {
        Iterator<String> languages = missingLanguages.iterator();
        StringBuffer buffer = new StringBuffer();
        while (languages.hasNext()) {
            buffer.append('\n');
            buffer.append(languages.next());
        }
        return buffer.toString();
    }

    public static Set<String> removeMissingLanguages(ProjectLanguageConfiguration config, ICProjectDescription description, Map<String, ILanguage> availableLanguages) {
        TreeSet<String> missingLanguages = new TreeSet<String>();
        for (Map.Entry entry : config.getFileMappings().entrySet()) {
            String path = (String)entry.getKey();
            Map configurationLanguageMappings = (Map)entry.getValue();
            for (Map.Entry mapping : configurationLanguageMappings.entrySet()) {
                String configurationId = (String)mapping.getKey();
                String languageId = (String)mapping.getValue();
                if (availableLanguages.containsKey(languageId)) continue;
                missingLanguages.add(languageId);
                ICConfigurationDescription configuration = description.getConfigurationById(configurationId);
                config.removeFileMapping(configuration, path);
            }
        }
        for (Map.Entry entry : config.getContentTypeMappings().entrySet()) {
            String configurationId = (String)entry.getKey();
            Map contentTypeLanguageMappings = (Map)entry.getValue();
            for (Map.Entry mapping : contentTypeLanguageMappings.entrySet()) {
                String contentTypeId = (String)mapping.getKey();
                String languageId = (String)mapping.getValue();
                if (availableLanguages.containsKey(languageId)) continue;
                missingLanguages.add(languageId);
                ICConfigurationDescription configuration = description.getConfigurationById(configurationId);
                config.removeContentTypeMapping(configuration, contentTypeId);
            }
        }
        return missingLanguages;
    }

    public static Set<String> removeMissingLanguages(WorkspaceLanguageConfiguration config, Map<String, ILanguage> availableLanguages) {
        TreeSet<String> missingLanguages = new TreeSet<String>();
        for (Map.Entry entry : config.getWorkspaceMappings().entrySet()) {
            String contentTypeId = (String)entry.getKey();
            String languageId = (String)entry.getValue();
            if (availableLanguages.containsKey(languageId)) continue;
            missingLanguages.add(languageId);
            config.removeWorkspaceMapping(contentTypeId);
        }
        return missingLanguages;
    }
}

