/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ArchiveFileFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.FolderSelectionDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SourceAttachmentBlock {
    private IStatusChangeListener fContext;
    private StringButtonDialogField fFileNameField;
    private SelectionButtonDialogField fWorkspaceButton;
    private SelectionButtonDialogField fExternalFolderButton;
    private IStatus fNameStatus;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private CLabel fFullPathResolvedLabel;
    private ICProject fProject;
    private ILibraryEntry fEntry;

    @Deprecated
    public SourceAttachmentBlock(IWorkspaceRoot root, IStatusChangeListener context, ILibraryEntry oldEntry) {
        this(context, oldEntry, null);
    }

    public SourceAttachmentBlock(IStatusChangeListener context, ILibraryEntry entry, ICProject project) {
        Assert.isNotNull((Object)entry);
        this.fContext = context;
        this.fEntry = entry;
        this.fProject = project;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fNameStatus = new StatusInfo();
        SourceAttachmentAdapter adapter = new SourceAttachmentAdapter();
        this.fFileNameField = new StringButtonDialogField(adapter);
        this.fFileNameField.setDialogFieldListener(adapter);
        this.fFileNameField.setLabelText(CPathEntryMessages.SourceAttachmentBlock_filename_label);
        this.fFileNameField.setButtonLabel(CPathEntryMessages.SourceAttachmentBlock_filename_externalfile_button);
        this.fWorkspaceButton = new SelectionButtonDialogField(8);
        this.fWorkspaceButton.setDialogFieldListener(adapter);
        this.fWorkspaceButton.setLabelText(CPathEntryMessages.SourceAttachmentBlock_filename_internal_button);
        this.fExternalFolderButton = new SelectionButtonDialogField(8);
        this.fExternalFolderButton.setDialogFieldListener(adapter);
        this.fExternalFolderButton.setLabelText(CPathEntryMessages.SourceAttachmentBlock_filename_externalfolder_button);
        this.setDefaults();
    }

    public void setDefaults() {
        if (this.fEntry.getSourceAttachmentPath() != null) {
            this.fFileNameField.setText(this.fEntry.getSourceAttachmentPath().toString());
        } else {
            this.fFileNameField.setText("");
        }
    }

    public IPath getSourceAttachmentPath() {
        if (this.fFileNameField.getText().length() == 0) {
            return null;
        }
        return new Path(this.fFileNameField.getText());
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    public IPath getSourceAttachmentPrefixMapping() {
        return null;
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        int widthHint = converter.convertWidthInCharsToPixels(60);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        Label message = new Label(composite, 16384);
        message.setLayoutData((Object)gd);
        message.setText(NLS.bind((String)CPathEntryMessages.SourceAttachmentBlock_message, (Object)this.fEntry.getLibraryPath().lastSegment()));
        this.fWorkspaceButton.doFillIntoGrid(composite, 1);
        this.fFileNameField.doFillIntoGrid(composite, 4);
        LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        DialogField.createEmptySpace(composite, 3);
        this.fExternalFolderButton.doFillIntoGrid(composite, 1);
        this.fFileNameField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    void attachmentChangeControlPressed(DialogField field) {
        IPath jarFilePath;
        if (field == this.fFileNameField && (jarFilePath = this.chooseExtJarFile()) != null) {
            this.fFileNameField.setText(jarFilePath.toString());
        }
    }

    void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        } else {
            if (field == this.fWorkspaceButton) {
                IPath jarFilePath = this.chooseInternalJarFile();
                if (jarFilePath != null) {
                    this.fFileNameField.setText(jarFilePath.toString());
                }
                return;
            }
            if (field == this.fExternalFolderButton) {
                IPath folderPath = this.chooseExtFolder();
                if (folderPath != null) {
                    this.fFileNameField.setText(folderPath.toString());
                }
                return;
            }
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString(this.fFileNameField.getText(), true));
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fNameStatus});
        this.fContext.statusChanged(status);
    }

    private boolean canBrowseFileName() {
        return true;
    }

    private String getResolvedLabelString(String path, boolean osPath) {
        IPath resolvedPath = this.getResolvedPath((IPath)new Path(path));
        if (resolvedPath != null) {
            if (osPath) {
                return resolvedPath.toOSString();
            }
            return resolvedPath.toString();
        }
        return "";
    }

    private IPath getResolvedPath(IPath path) {
        return path;
    }

    private IStatus updateFileNameStatus() {
        StatusInfo status = new StatusInfo();
        String fileName = this.fFileNameField.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(CPathEntryMessages.SourceAttachmentBlock_filename_error_notvalid);
            return status;
        }
        Path filePath = new Path(fileName);
        File file = filePath.toFile();
        IResource res = this.fWorkspaceRoot.findMember((IPath)filePath);
        if (res != null && res.getLocation() != null) {
            file = res.getLocation().toFile();
        }
        if (!file.exists()) {
            String message = NLS.bind((String)CPathEntryMessages.SourceAttachmentBlock_filename_error_filenotexists, (Object)filePath.toString());
            status.setError(message);
            return status;
        }
        return status;
    }

    private IPath chooseExtJarFile() {
        Path currPath = new Path(this.fFileNameField.getText());
        if (currPath.isEmpty()) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)currPath)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(CPathEntryMessages.SourceAttachmentBlock_extjardialog_text);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return new Path(res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        Path currPath = new Path(this.fFileNameField.getText());
        if (currPath.isEmpty()) {
            currPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath((IPath)currPath)) {
            currPath = currPath.removeLastSegments(1);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(CPathEntryMessages.SourceAttachmentBlock_extfolderdialog_text);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return new Path(res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternalJarFile() {
        String initSelection = this.fFileNameField.getText();
        Class[] acceptedClasses = new Class[]{IFolder.class, IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArchiveFileFilter filter = new ArchiveFileFilter(null, false);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSel = null;
        if (initSelection.length() > 0) {
            initSel = this.fWorkspaceRoot.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.setValidator(validator);
        dialog.addFilter(filter);
        dialog.setTitle(CPathEntryMessages.SourceAttachmentBlock_intjardialog_title);
        dialog.setMessage(CPathEntryMessages.SourceAttachmentBlock_intjardialog_message);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSel);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return CUIPlugin.getActiveWorkbenchShell();
    }

    public IRunnableWithProgress getRunnable(ICProject jproject, Shell shell) {
        this.fProject = jproject;
        return this.getRunnable(shell);
    }

    public IRunnableWithProgress getRunnable(final Shell shell) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SourceAttachmentBlock.this.attachSource(shell, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected void attachSource(Shell shell, IProgressMonitor monitor) throws CoreException {
        boolean isExported = this.fEntry.isExported();
        ILibraryEntry newEntry = CoreModel.newLibraryEntry((IPath)this.fEntry.getPath(), (IPath)this.fEntry.getBasePath(), (IPath)this.fEntry.getLibraryPath(), (IPath)this.getSourceAttachmentPath(), (IPath)this.getSourceAttachmentRootPath(), (IPath)this.getSourceAttachmentPrefixMapping(), (boolean)isExported);
        this.updateProjectPathEntry(shell, this.fProject, newEntry, monitor);
    }

    private void updateProjectPathEntry(Shell shell, ICProject cproject, ILibraryEntry newEntry, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] oldClasspath = cproject.getRawPathEntries();
        int nEntries = oldClasspath.length;
        ArrayList<Object> newEntries = new ArrayList<Object>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath jarPath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IPathEntry curr = oldClasspath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)jarPath)) {
                newEntries.add(newEntry);
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (newEntry.getSourceAttachmentPath() == null || !this.putJarOnClasspathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IPathEntry[] newPathEntries = newEntries.toArray(new IPathEntry[newEntries.size()]);
        cproject.setRawPathEntries(newPathEntries, monitor);
    }

    private boolean putJarOnClasspathDialog(Shell shell) {
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = CPathEntryMessages.SourceAttachmentBlock_putoncpdialog_title;
                String message = CPathEntryMessages.SourceAttachmentBlock_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)CUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(field);
        }
    }
}

