/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.AbstractPathOptionBlock;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathIncludeSymbolEntryBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathIncludeSymbolEntryPage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathIncludeSymbolEntryPerFilePage;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewIncludesSymbolsTabBlock
extends AbstractPathOptionBlock
implements IStatusChangeListener {
    private CPathIncludeSymbolEntryBasePage fIncludeSymbols;
    private List<CPElement> fCPaths;
    private Composite fComposite;

    public NewIncludesSymbolsTabBlock(IStatusChangeListener context, int pageToShow) {
        super(context, pageToShow);
    }

    @Override
    protected void addTab(ICOptionPage tab) {
        tab.setContainer(this);
        tab.createControl(this.fComposite);
        this.addOptionPage(tab);
    }

    @Override
    protected void addTabs() {
    }

    @Override
    public Control createContents(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.addPage(this.fIncludeSymbols);
        this.setCurrentPage(this.fIncludeSymbols);
        this.initializingTabs = false;
        if (this.getCProject() != null) {
            this.fIncludeSymbols.init(this.getCElement(), this.fCPaths);
        }
        Dialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    @Override
    protected List<CPElement> getCPaths() {
        if (this.fIncludeSymbols != null) {
            return this.fIncludeSymbols.getCPaths();
        }
        return this.fCPaths;
    }

    @Override
    protected int[] getFilteredTypes() {
        return new int[]{16, 64, 32};
    }

    @Override
    protected int[] getAppliedFilteredTypes() {
        return new int[]{16, 64};
    }

    @Override
    protected void initialize(ICElement element, List<CPElement> cPaths) {
        this.fCPaths = cPaths;
        this.fIncludeSymbols = element instanceof ICProject ? new CPathIncludeSymbolEntryPage(this) : new CPathIncludeSymbolEntryPerFilePage(this);
        if (this.fIncludeSymbols != null) {
            this.fIncludeSymbols.init(element, cPaths);
        }
        this.doStatusLineUpdate();
        this.initializeTimeStamps();
    }

    @Override
    public void statusChanged(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                this.getPathStatus().setError(status.getMessage());
                break;
            }
            case 1: {
                this.getPathStatus().setInfo(status.getMessage());
                break;
            }
            case 2: {
                this.getPathStatus().setWarning(status.getMessage());
                break;
            }
            default: {
                this.getPathStatus().setOK();
            }
        }
        this.updateBuildPathStatus();
        this.doStatusLineUpdate();
    }
}

