/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ArchiveFileFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.SourceAttachmentDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPathLibraryEntryPage
extends CPathBasePage {
    private ListDialogField<CPElement> fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private TreeListDialogField<CPElement> fLibrariesList;
    private IWorkspaceRoot fWorkspaceRoot;
    private final int IDX_ADD_LIBEXT = 0;
    private final int IDX_ADD_LIB = 1;
    private final int IDX_ADD_CONTRIBUTED = 2;
    private final int IDX_EDIT = 4;
    private final int IDX_REMOVE = 5;
    private final int IDX_EXPORT = 7;

    public CPathLibraryEntryPage(ListDialogField<CPElement> cPathList) {
        super(CPathEntryMessages.LibrariesEntryPage_title);
        this.setDescription(CPathEntryMessages.LibrariesEntryPage_description);
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = cPathList;
        LibrariesAdapter adapter = new LibrariesAdapter();
        String[] stringArray = new String[8];
        stringArray[0] = CPathEntryMessages.LibrariesEntryPage_libraries_addextlib_button;
        stringArray[1] = CPathEntryMessages.LibrariesEntryPage_libraries_addworkspacelib_button;
        stringArray[2] = CPathEntryMessages.LibrariesEntryPage_libraries_addcontriblib_button;
        stringArray[4] = CPathEntryMessages.LibrariesEntryPage_libraries_edit_button;
        stringArray[5] = CPathEntryMessages.LibrariesEntryPage_libraries_remove_button;
        stringArray[7] = CPathEntryMessages.LibrariesEntryPage_libraries_export_button;
        String[] buttonLabels = stringArray;
        this.fLibrariesList = new TreeListDialogField<CPElement>(adapter, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(CPathEntryMessages.LibrariesEntryPage_libraries_label);
        this.fLibrariesList.setViewerComparator((ViewerComparator)new CPElementSorter());
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.enableButton(5, false);
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.setTreeExpansionLevel(2);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.ar_obj.gif");
    }

    public void init(ICProject cproject) {
        this.fCurrCProject = cproject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List<CPElement> cpelements = this.filterList(this.fCPathList.getElements());
        this.fLibrariesList.setElements(cpelements);
    }

    @Override
    public List<?> getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 1;
    }

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void performDefaults() {
    }

    @Override
    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPElementSorter());
        this.setControl((Control)composite);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_libraries");
    }

    protected void libraryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 1: {
                libentries = this.openLibFileDialog(null);
                break;
            }
            case 0: {
                libentries = this.openExtLibFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                this.editEntry();
                return;
            }
            case 5: {
                this.removeEntry();
                return;
            }
            case 7: {
                this.exportEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List<CPElement> cplist = this.fLibrariesList.getElements();
            ArrayList<CPElement> elementsToAdd = new ArrayList<CPElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fCPathList.addElements(elementsToAdd);
            if (index == 1) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private boolean canExport(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElement) {
                CPElement curr = (CPElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
                IPath base_ref = (IPath)curr.getAttribute("base-ref");
                if (base_ref != null && !base_ref.equals((Object)Path.EMPTY)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void exportEntry() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            ((CPElement)elem).setExported(!((CPElement)elem).isExported());
            this.fLibrariesList.refresh(elem);
        }
    }

    protected void libraryPageDoubleClicked(TreeListDialogField<CPElement> field) {
        List<Object> selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libraryPageKeyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute) {
                CPElementAttribute attrib = (CPElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fCPathList.removeElements(selElements);
            this.fLibrariesList.removeElements(selElements);
        }
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute ? ((CPElementAttribute)elem).getValue() == null : elem instanceof CPElement && (curr = (CPElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPElement)elem);
        } else if (elem instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("sourcepath")) {
            CPElement selElement = elem.getParent();
            ILibraryEntry libEntry = (ILibraryEntry)selElement.getPathEntry();
            SourceAttachmentDialog dialog = new SourceAttachmentDialog(this.getShell(), libEntry, this.fCurrCProject, true);
            if (dialog.open() == 0) {
                selElement.setAttribute("sourcepath", dialog.getSourceAttachmentPath());
                this.fLibrariesList.refresh();
                this.fCPathList.refresh();
            }
        }
    }

    private void editElementEntry(CPElement elem) {
        CPElement[] res = null;
        switch (elem.getEntryKind()) {
            case 1: {
                IPath p = (IPath)elem.getAttribute("librarypath");
                res = p.isAbsolute() ? this.openExtLibFileDialog(elem) : this.openLibFileDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
        }
    }

    protected void libraryPageSelectionChanged(DialogField field) {
        List<Object> selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(4, this.canEdit(selElements));
        this.fLibrariesList.enableButton(5, this.canRemove(selElements));
        this.fLibrariesList.enableButton(7, this.canExport(selElements));
    }

    private IFile[] getUsedLibFiles(CPElement existing) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        List<CPElement> cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPElement elem = cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource);
            }
            ++i;
        }
        return res.toArray(new IFile[res.size()]);
    }

    private CPElement newCPLibraryElement(IPath libraryPath) {
        CPElement element = new CPElement(this.fCurrCProject, 1, this.fProjPath, null);
        element.setAttribute("librarypath", libraryPath);
        return element;
    }

    private CPElement[] openExtLibFileDialog(CPElement existing) {
        String res;
        String title = CPathEntryMessages.LibrariesEntryPage_ExtLibDialog_new_title;
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.a;*.so;*.dll;*.lib"});
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        CPElement[] elems = new CPElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            elems[i] = this.newCPLibraryElement(path);
            ++i;
        }
        return elems;
    }

    private CPElement[] openLibFileDialog(CPElement existing) {
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, existing == null);
        ArchiveFileFilter filter = new ArchiveFileFilter(this.getUsedLibFiles(existing), true);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        String title = existing == null ? CPathEntryMessages.LibrariesEntryPage_ExtLibDialog_new_title : CPathEntryMessages.LibrariesEntryPage_ExtLibDialog_edit_title;
        String message = existing == null ? CPathEntryMessages.LibrariesEntryPage_ExtLibDialog_new_description : CPathEntryMessages.LibrariesEntryPage_ExtLibDialog_edit_description;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (existing == null) {
            dialog.setInitialSelection((Object)this.fCurrCProject.getProject());
        } else {
            dialog.setInitialSelection((Object)existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPElement[] res = new CPElement[elements.length];
            int i = 0;
            while (i < res.length) {
                IPath path = ((IResource)elements[i]).getLocation();
                res[i] = this.newCPLibraryElement(path);
                ++i;
            }
            return res;
        }
        return null;
    }

    protected IPathEntry[] getRawPathEntries() {
        IPathEntry[] currEntries = new IPathEntry[this.fCPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPElement curr = this.fCPathList.getElement(i);
            currEntries[i] = curr.getPathEntry();
            ++i;
        }
        return currEntries;
    }

    protected CPElement[] openContainerSelectionDialog(CPElement existing) {
        String title;
        IContainerEntry elem = null;
        if (existing == null) {
            title = CPathEntryMessages.LibrariesEntryPage_ContainerDialog_new_title;
        } else {
            title = CPathEntryMessages.LibrariesEntryPage_ContainerDialog_edit_title;
            elem = (IContainerEntry)existing.getPathEntry();
        }
        CPathContainerWizard wizard = new CPathContainerWizard(elem, null, (ICElement)this.fCurrCProject, this.getRawPathEntries(), new int[]{1});
        wizard.setWindowTitle(title);
        if (CPathContainerWizard.openWizard(this.getShell(), wizard) == 0) {
            IPathEntry parent = wizard.getEntriesParent();
            IPathEntry[] elements = wizard.getEntries();
            if (elements != null) {
                CPElement[] res = new CPElement[elements.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPElement(this.fCurrCProject, 1, this.fProjPath, null);
                    res[i].setAttribute("librarypath", ((ILibraryEntry)elements[i]).getLibraryPath());
                    res[i].setAttribute("base-ref", parent.getPath());
                    ++i;
                }
                return res;
            }
        }
        return null;
    }

    private boolean canEdit(List<?> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPElement) {
            CPElement curr = (CPElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        return elem instanceof CPElementAttribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter<CPElement> {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPElement> field, int index) {
            CPathLibraryEntryPage.this.libraryPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPElement> field) {
            CPathLibraryEntryPage.this.libraryPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPElement> field) {
            CPathLibraryEntryPage.this.libraryPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
            CPathLibraryEntryPage.this.libraryPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElementAttribute) {
                return ((CPElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPElement> field, Object element) {
            return false;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

