/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CViewLabelProvider
extends AppearanceAwareLabelProvider {
    public CViewLabelProvider(int textFlags, int imageFlags) {
        super(textFlags, imageFlags);
    }

    public String getText(Object element) {
        ITranslationUnit unit;
        ICElement parent;
        if (element instanceof IncludeReferenceProxy) {
            IIncludeReference ref = ((IncludeReferenceProxy)((Object)element)).getReference();
            IPath location = ref.getPath();
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(location);
            if (containers.length > 0) {
                ICProject prj = ref.getCProject();
                if (prj != null) {
                    int i = 0;
                    while (i < containers.length) {
                        IContainer container = containers[i];
                        IProject project = container.getProject();
                        if (project != null && project.equals((Object)prj.getProject())) {
                            return container.getFullPath().makeRelative().toString();
                        }
                        ++i;
                    }
                }
                return containers[0].getFullPath().makeRelative().toString();
            }
        } else if (element instanceof IIncludeReference) {
            IIncludeReference ref = (IIncludeReference)element;
            ICElement parent2 = ref.getParent();
            if (parent2 instanceof IIncludeReference) {
                IPath p = ref.getPath();
                IPath parentLocation = ((IIncludeReference)parent2).getPath();
                if (parentLocation.isPrefixOf(p)) {
                    p = p.setDevice(null);
                    p = p.removeFirstSegments(parentLocation.segmentCount());
                }
                return p.toString();
            }
        } else if (element instanceof ITranslationUnit && (parent = (unit = (ITranslationUnit)element).getParent()) instanceof IIncludeReference) {
            IPath p = unit.getPath();
            IPath parentLocation = ((IIncludeReference)parent).getPath();
            if (parentLocation.isPrefixOf(p)) {
                p = p.setDevice(null);
                p = p.removeFirstSegments(parentLocation.segmentCount());
            }
            return p.toString();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IncludeReferenceProxy) {
            IIncludeReference reference = ((IncludeReferenceProxy)((Object)element)).getReference();
            IPath path = reference.getPath();
            IContainer container = reference.getCModel().getWorkspace().getRoot().getContainerForLocation(path);
            if (container != null && container.isAccessible()) {
                Object desc = CPluginImages.DESC_OBJS_INCLUDES_FOLDER_WORKSPACE;
                desc = new CElementImageDescriptor((ImageDescriptor)desc, 0, CElementImageProvider.SMALL_SIZE);
                return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else if (element instanceof IIncludeReference) {
            Object desc = CElementImageProvider.getImageDescriptor(12);
            desc = new CElementImageDescriptor((ImageDescriptor)desc, 0, CElementImageProvider.SMALL_SIZE);
            return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
        }
        return super.getImage(element);
    }
}

