/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.mylyn.internal.ui.CDTStructureBridge;
import org.eclipse.cdt.mylyn.internal.ui.CDTUIBridgePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingListener
extends AbstractContextListener {
    private final CEditor editor;
    private ProjectionAnnotationModel updater;
    private static CDTStructureBridge bridge = (CDTStructureBridge)ContextCorePlugin.getDefault().getStructureBridge("c/c++");
    private boolean enabled = false;
    private Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                    ActiveFoldingListener.this.enabled = true;
                } else {
                    ActiveFoldingListener.this.enabled = false;
                }
                ActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public ActiveFoldingListener(CEditor editor) {
        this.editor = editor;
        if (ContextUiPlugin.getDefault() == null) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.initFoldingFailure")));
        } else {
            ContextCorePlugin.getContextManager().addListener((AbstractContextListener)this);
            ContextUiPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
            this.enabled = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
            this.updateFolding();
        }
    }

    protected void collapseElements(ICElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.collapse(elements[i]);
            ++i;
        }
    }

    private void collapse(ICElement element) {
        CSourceViewer viewer = (CSourceViewer)this.editor.getViewer();
        viewer.doOperation(18);
    }

    protected void expandElements(ICElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.expand(elements[i]);
            ++i;
        }
    }

    private void expand(ICElement element) {
        CSourceViewer viewer = (CSourceViewer)this.editor.getViewer();
        viewer.doOperation(17);
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this);
        ContextUiPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public static void resetProjection(CEditor CEditor2) {
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCorePlugin.getContextManager().isContextActive()) {
            this.editor.resetProjection();
        } else {
            if (this.editor.getInputCElement() == null) {
                return;
            }
            try {
                ArrayList<ICElement> toExpand = new ArrayList<ICElement>();
                ArrayList<ICElement> toCollapse = new ArrayList<ICElement>();
                ICElement element = this.editor.getInputCElement();
                if (element instanceof ITranslationUnit) {
                    ITranslationUnit compilationUnit = (ITranslationUnit)element;
                    List<ICElement> allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    for (ICElement child : allChildren) {
                        IInteractionElement interactionElement = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                this.collapseElements(toCollapse.toArray(new ICElement[toCollapse.size()]));
                this.expandElements(toExpand.toArray(new ICElement[toExpand.size()]));
            }
            catch (Exception e) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.updateFoldingFailure"), (Throwable)e));
            }
        }
    }

    private static List<ICElement> getAllChildren(IParent parentElement) {
        ArrayList<ICElement> allChildren = new ArrayList<ICElement>();
        try {
            ICElement[] iCElementArray = parentElement.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement child = iCElementArray[n2];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return allChildren;
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            if (this.updater == null || !this.enabled) {
                return;
            }
            Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
            if (!(object instanceof IMethod)) continue;
            IMethod member = (IMethod)object;
            if (element.getInterest().isInteresting()) {
                this.expandElements(new ICElement[]{member});
                try {
                    ICElement[] childsChildren;
                    ICElement[] children = ((IParent)member).getChildren();
                    if (children.length != 1) continue;
                    this.expandElements(new ICElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.expandElements(new ICElement[]{childsChildren[0]});
                }
                catch (CModelException cModelException) {}
                continue;
            }
            this.collapseElements(new ICElement[]{member});
        }
    }

    public void contextActivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
            this.updateFolding();
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void elementDeleted(IInteractionElement node) {
    }
}

