/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ProblemsLabelDecorator;
import org.eclipse.cdt.mylyn.internal.ui.CDTStructureBridge;
import org.eclipse.cdt.mylyn.internal.ui.CDTUIBridgePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.swt.graphics.Image;

public class CDTContextLabelProvider
extends AppearanceAwareLabelProvider {
    private static final String LABEL_ELEMENT_MISSING_KEY = "MylynCDT.missingElementLabel";
    private static final String CONTAINMENT_RELATION_NAME_KEY = "MylynCDT.containmentRelation";

    public CDTContextLabelProvider() {
        super(0x40000001, 3);
    }

    public String getText(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if ("c/c++".equals(node.getContentType())) {
                ICElement element = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
                if (element == null) {
                    return CDTUIBridgePlugin.getResourceString(LABEL_ELEMENT_MISSING_KEY);
                }
                return this.getTextForElement(element);
            }
        } else {
            if (object instanceof IInteractionRelation) {
                return this.getNameForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            }
            if (object instanceof ICElement) {
                return this.getTextForElement((ICElement)object);
            }
        }
        return super.getText(object);
    }

    private String getTextForElement(ICElement element) {
        if (element.exists()) {
            return super.getText((Object)element);
        }
        return CDTUIBridgePlugin.getResourceString(LABEL_ELEMENT_MISSING_KEY);
    }

    public Image getImage(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            if (node.getContentType().equals("c/c++")) {
                ICElement element = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
                if (element != null) {
                    return super.getImage((Object)element);
                }
                return null;
            }
        } else if (object instanceof IInteractionRelation) {
            ImageDescriptor descriptor = this.getIconForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            if (descriptor != null) {
                return ContextUiImages.getImage((ImageDescriptor)descriptor);
            }
            return null;
        }
        return super.getImage(object);
    }

    private ImageDescriptor getIconForRelationship(String relationshipHandle) {
        return null;
    }

    private String getNameForRelationship(String relationshipHandle) {
        if (relationshipHandle.equals("org.eclipse.mylyn.core.model.edges.containment")) {
            return CDTUIBridgePlugin.getResourceString(CONTAINMENT_RELATION_NAME_KEY);
        }
        return null;
    }

    public static AppearanceAwareLabelProvider createCDTUiLabelProvider() {
        AppearanceAwareLabelProvider cdtUiLabelProvider = new AppearanceAwareLabelProvider(0x40000001, 3);
        cdtUiLabelProvider.addLabelDecorator((ILabelDecorator)new ProblemsLabelDecorator(null));
        return cdtUiLabelProvider;
    }
}

