/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.mylyn.internal.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingEditorTracker
extends AbstractEditorTracker {
    protected Map<CEditor, ActiveFoldingListener> editorListenerMap = new HashMap<CEditor, ActiveFoldingListener>();

    public void editorOpened(IEditorPart part) {
        if (part instanceof CEditor) {
            this.registerEditor((CEditor)part);
        }
    }

    public void editorClosed(IEditorPart part) {
        if (part instanceof CEditor) {
            this.unregisterEditor((CEditor)part);
        }
    }

    public void registerEditor(CEditor editor) {
        if (this.editorListenerMap.containsKey(editor)) {
            return;
        }
        ActiveFoldingListener listener = new ActiveFoldingListener(editor);
        this.editorListenerMap.put(editor, listener);
    }

    public void unregisterEditor(CEditor editor) {
        ActiveFoldingListener listener = this.editorListenerMap.get(editor);
        if (listener != null) {
            listener.dispose();
        }
        this.editorListenerMap.remove(editor);
    }

    public Map<CEditor, ActiveFoldingListener> getEditorListenerMap() {
        return this.editorListenerMap;
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }
}

